package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 核销申请活动表 实体类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit_act")
@CrmTable(name = "tpm_audit_act",tableNote = "TPM-核销申请活动表")
public class TpmAuditActEntity extends CrmExtEntity<TpmAuditActEntity> {

    /**
     * 核销申请编码
     */
    @CrmColumn(name = "audit_code", length = 32,note = "核销申请编码")
    private String auditCode;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 100,note = "活动名称")
    private String actName;

    /**
     * 开始日期
     */
    @CrmColumn(name = "begin_date", length = 32,note = "开始日期")
    private String beginDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date_second", length = 32,note = "开始时间")
    private String beginDateSecond;

    /**
     * 结束日期
     */
    @CrmColumn(name = "end_date", length = 32,note = "结束日期")
    private String endDate;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date_second", length = 32,note = "结束时间")
    private String endDateSecond;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

    /**
     * 申请人
     */
    @CrmColumn(name = "act_create_user", length = 60,note = "申请人")
    private String actCreateUser;

}
