package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 核销明细客户信息表实体类
 *
 * @author gavin
 * @date 2021-12-20 13:49:09
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit_detail_customer")
@CrmTable(name = "tpm_audit_detail_customer", tableNote = "核销明细客户信息表")
public class TpmAuditDetailCustomerEntity extends CrmExtTenEntity<TpmAuditDetailCustomerEntity> {


    /**
     * 客户编码
     */
    @CrmColumn(name = "CUSTOMER_CODE", length = 60, note = "客户编码")
    private String customerCode;


    /**
     * 客户名称
     */
    @CrmColumn(name = "CUSTOMER_NAME", length = 100, note = "客户名称")
    private String customerName;


    /**
     * 核销金额
     */
    @CrmColumn(name = "AUDIT_APPLY_AMOUNT", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "核销金额")
    private BigDecimal auditApplyAmount;


    /**
     * 核销明细编码
     */
    @CrmColumn(name = "AUDIT_DETAIL_CODE", length = 60, note = "核销明细编码")
    private String auditDetailCode;

    /**
     * 已上账金额
     */
    @CrmColumn(name = "FEE_USED", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "已上账金额")
    private BigDecimal feeUsed;

    /**
     * 是否完全上账(Y/N)
     */
    @CrmColumn(name = "is_all_fee_used", length = 10,note = "是否完全上账(Y/N)")
    private String isAllFeeUsed;
}
