package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 核销申请资料表 实体类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit_file")
@CrmTable(name = "tpm_audit_file",tableNote = "TPM-核销申请资料表")
public class TpmAuditFileEntity extends CrmExtEntity<TpmAuditFileEntity> {

    /**
     * 核销申请编码
     */
    @CrmColumn(name = "audit_code", length = 32,note = "核销申请编码")
    private String auditCode;

    /**
     * 核销申请明细编码
     */
    @CrmColumn(name = "audit_detail_code", length = 32,note = "核销申请明细编码")
    private String auditDetailCode;

    /**
     * 核销申请资料类型(1,核销资料,2,活动取证资料,3,审批资料)
     */
    @CrmColumn(name = "audit_file_type",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "核销申请资料类型(1,核销资料,2,活动取证资料,3,审批资料)")
    private Integer auditFileType;

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;

    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 60,note = "活动细类名称")
    private String fineName;
    /**
     * 核销采集示例编码
     */
    @CrmColumn(name = "example_code", length = 32,note = "核销采集示例编码")
    private String exampleCode;
    /**
     * 要求核销资料名称(多个名字)
     */
    @CrmColumn(name = "audit_require_names", length = 200,note = "要求核销资料名称(多个名字)")
    private String auditRequireNames;

    /**
     * 描述
     */
    @CrmColumn(name = "file_desc", length = 60,note = "描述")
    private String fileDesc;

    /**
     * 示例文件集合
     */
    @CrmColumn(name = "example_files", length = 200,note = "示例文件集合")
    private String exampleFiles;

    /**
     * 文件地址
     */
    @CrmColumn(name = "address_url", length = 200,note = "文件地址")
    private String addressUrl;

    /**
     * 对象名称
     */
    @CrmColumn(name = "object_name", length = 100,note = "对象名称")
    private String objectName;
}
