package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;


/**
 * 核销发票
 *
 * @author gavin
 * @date 2021-12-16 16:29:22
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit_invoice")
@CrmTable(name = "tpm_audit_invoice", tableNote = "")
public class TpmAuditInvoiceEntity extends CrmExtTenEntity<TpmAuditInvoiceEntity> {

    @CrmColumn(name = "audit_code", length = 60, note = "核销编码")
    private String auditCode;

    /**
     * 发票类型字典值
     */
    @CrmColumn(name = "invoice_type", length = 40, note = "发票类型字典值")
    private String invoiceType;


    /**
     * 发票代码
     */
    @CrmColumn(name = "invoice_code", length = 60, note = "发票代码")
    private String invoiceCode;


    /**
     * 发票号码
     */
    @CrmColumn(name = "invoice_number", length = 60, note = "发票号码")
    private String invoiceNumber;


    /**
     * 开票日期
     */
    @CrmColumn(name = "invoicing_date", length = 20, note = "开票日期")
    private String invoicingDate;


    /**
     * 校验码
     */
    @CrmColumn(name = "check_code", length = 60, note = "校验码")
    private String checkCode;


    /**
     * 买方名称
     */
    @CrmColumn(name = "purchaser_name", length = 100, note = "买方名称")
    private String purchaserName;


    /**
     * 买方纳税人号码
     */
    @CrmColumn(name = "purchaser_taxpayer_number", length = 100, note = "买方纳税人号码")
    private String purchaserTaxpayerNumber;


    /**
     * 买方地址及电话信息
     */
    @CrmColumn(name = "purchaser_info", length = 100, note = "买方地址及电话信息")
    private String purchaserInfo;


    /**
     * 买方账户
     */
    @CrmColumn(name = "purchaser_account", length = 100, note = "买方账户")
    private String purchaserAccount;


    /**
     * 卖方名称
     */
    @CrmColumn(name = "seller_name", length = 100, note = "卖方名称")
    private String sellerName;


    /**
     * 卖方纳税人号码
     */
    @CrmColumn(name = "seller_taxpayer_number", length = 100, note = "卖方纳税人号码")
    private String sellerTaxpayerNumber;


    /**
     * 卖方地址及电话信息
     */
    @CrmColumn(name = "seller_info", length = 100, note = "卖方地址及电话信息")
    private String sellerInfo;


    /**
     * 卖方账户
     */
    @CrmColumn(name = "seller_account", length = 100, note = "卖方账户")
    private String sellerAccount;


    /**
     * 金额
     */
    @CrmColumn(name = "amount", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "金额")
    private BigDecimal amount;


    /**
     * 税率
     */
    @CrmColumn(name = "tax_rate", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "税率")
    private BigDecimal taxRate;


    /**
     * 税额
     */
    @CrmColumn(name = "tax_amount", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "税额")
    private BigDecimal taxAmount;


    /**
     * 含税总金额
     */
    @CrmColumn(name = "total_amount", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "含税总金额")
    private BigDecimal totalAmount;

    /**
     * 已使用金额
     */
    @CrmColumn(name = "used_amount", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "已使用金额")
    private BigDecimal usedAmount;

    /**
     * 可用金额
     */
    @CrmColumn(name = "available_amount", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "可用金额")
    private BigDecimal availableAmount;

    /**
     * 本次使用金额
     */
    @CrmColumn(name = "use_amount", mysqlType = "decimal(20,4)", oracleType = "NUMBER(20,4)", note = "本次使用金额")
    private BigDecimal useAmount;
}
