package com.biz.crm.audit.service;

import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;

import java.util.List;
import java.util.Map;

/**
 * 核销申请活动表 接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
public interface ITpmAuditActService extends IService<TpmAuditActEntity> {

    /**
     * 列表
     * @param tpmAuditActReqVo
     * @return PageResult<TpmAuditActRespVo>
     */
    PageResult<TpmAuditActRespVo> findList(TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 查询
     * @param tpmAuditActReqVo
     * @return TpmAuditActRespVo
     */
    TpmAuditActRespVo query(TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 新增
     * @param tpmAuditActReqVo
     * @return
     */
    void save(TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 更新
     * @param tpmAuditActReqVo
     * @return
     */
    void update(TpmAuditActReqVo tpmAuditActReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

