package com.biz.crm.audit.service;

import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;

import java.util.List;
import java.util.Map;

/**
 * 核销申请明细表 接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
public interface ITpmAuditDetailService extends IService<TpmAuditDetailEntity> {

    /**
     * 列表
     * @param tpmAuditDetailReqVo
     * @return PageResult<TpmAuditDetailRespVo>
     */
    PageResult<TpmAuditDetailRespVo> findList(TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 上账核销明细查询
     * @param tpmAuditDetailReqVo
     * @return TpmAuditDetailRespVo
     */
    PageResult<TpmAuditDetailRespVo> findAccountAuditDetail(TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 新增
     * @param tpmAuditDetailReqVo
     * @return
     */
    void save(TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 更新
     * @param tpmAuditDetailReqVo
     * @return
     */
    void update(TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

