package com.biz.crm.audit.service;

import com.biz.crm.audit.model.TpmAuditFileEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileReqVo;

import java.util.List;
import java.util.Map;

/**
 * 核销申请资料表 接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
public interface ITpmAuditFileService extends IService<TpmAuditFileEntity> {

    /**
     * 列表
     * @param tpmAuditFileReqVo
     * @return PageResult<TpmAuditFileRespVo>
     */
    PageResult<TpmAuditFileRespVo> findList(TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 查询
     * @param tpmAuditFileReqVo
     * @return TpmAuditFileRespVo
     */
    TpmAuditFileRespVo query(TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 新增
     * @param tpmAuditFileReqVo
     * @return
     */
    void save(TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 更新
     * @param tpmAuditFileReqVo
     * @return
     */
    void update(TpmAuditFileReqVo tpmAuditFileReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

