package com.biz.crm.audit.service;

import com.biz.crm.audit.model.TpmAuditInvoiceEntity;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditInvoiceReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditInvoiceRespVo;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 接口
 *
 * @author gavin
 * @date 2021-12-17 15:12:37
 */
public interface ITpmAuditInvoiceService extends IService<TpmAuditInvoiceEntity> {

    /**
     * 列表
     * @param tpmAuditInvoiceReqVo
     * @return PageResult<TpmAuditInvoiceRespVo>
     */
    PageResult<TpmAuditInvoiceRespVo> findList(TpmAuditInvoiceReqVo tpmAuditInvoiceReqVo);

    /**
     * 查询
     * @param tpmAuditInvoiceReqVo
     * @return TpmAuditInvoiceRespVo
     */
    TpmAuditInvoiceRespVo query(TpmAuditInvoiceReqVo tpmAuditInvoiceReqVo);

    /**
     * 新增
     * @param tpmAuditInvoiceReqVo
     * @return
     */
    void save(TpmAuditInvoiceReqVo tpmAuditInvoiceReqVo);

    /**
     * 更新
     * @param tpmAuditInvoiceReqVo
     * @return
     */
    void update(TpmAuditInvoiceReqVo tpmAuditInvoiceReqVo);

    /**
     * 删除
     * @param tpmAuditInvoiceReqVo
     * @return
     */
    void deleteBatch(TpmAuditInvoiceReqVo tpmAuditInvoiceReqVo);

    /**
     * 启用
     * @param tpmAuditInvoiceReqVo
     * @return
     */
    void enableBatch(TpmAuditInvoiceReqVo tpmAuditInvoiceReqVo);

    /**
     * 禁用
     * @param tpmAuditInvoiceReqVo
     * @return
     */
    void disableBatch(TpmAuditInvoiceReqVo tpmAuditInvoiceReqVo);
}

