package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.audit.mapper.TpmAuditDetailReplenishmentProductMapper;
import com.biz.crm.audit.model.TpmAuditDetailReplenishmentProductEntity;
import com.biz.crm.nebular.tpm.audit.TpmAuditDetailReplenishmentProductVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import org.apache.commons.collections4.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 核销申请明细表 接口实现
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAuditDetailServiceExpandImpl")
public class TpmAuditDetailServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAuditDetailMapper, TpmAuditDetailEntity> implements ITpmAuditDetailService {

    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;

    @Resource
    private TpmAuditDetailReplenishmentProductMapper replenishmentProductMapper;

    @Resource
    private ActServiceHelper serviceHelper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAuditDetailRespVo> findList(TpmAuditDetailReqVo reqVo){
        Page<TpmAuditDetailRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setSelectedCodeList(serviceHelper.dealSelectedCodeList(reqVo.getSelectedCode(),reqVo.getSelectedCodeList()));
        List<TpmAuditDetailRespVo> list = tpmAuditDetailMapper.findList(page, reqVo);
        return PageResult.<TpmAuditDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 上账核销明细查询
     * @param reqVo
     * @return tpmAuditDetailRespVo
     */
    @Override
    public PageResult<TpmAuditDetailRespVo> findAccountAuditDetail(TpmAuditDetailReqVo reqVo){
        Page<TpmAuditDetailRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmAuditDetailRespVo> list = tpmAuditDetailMapper.findAccountAuditDetail(page,reqVo);
        //如果关联的客户信息,就取客户信息上申请的核销申请金额等信息
        list.stream().filter(Objects::nonNull).forEach(o->{
            if(o.getRelCustomerCode() != null){
                o.setCustomerCode(o.getRelCustomerCode());
                o.setCustomerName(o.getRelCustomerName());
                o.setAuditApplyAmount(o.getRelAuditApplyAmount());
                o.setFeeUsed(o.getRelFeeUsed());
            }
            o.setFeeAccessible(o.getAuditApplyAmount().subtract(Optional.ofNullable(o.getFeeUsed()).orElse(BigDecimal.ZERO)));
        });
        if(CollectionUtils.isNotEmpty(list)){
            List<String> auditDetailsCodes = list.stream().map(TpmAuditDetailRespVo::getAuditDetailCode).collect(Collectors.toList());
            List<TpmAuditDetailReplenishmentProductEntity> replenishmentProductEntities = replenishmentProductMapper.selectList(Wrappers.<TpmAuditDetailReplenishmentProductEntity>lambdaQuery()
                    .in(TpmAuditDetailReplenishmentProductEntity::getAuditDetailCode, auditDetailsCodes));
            if (CollectionUtils.isNotEmpty(replenishmentProductEntities)) {
                List<TpmAuditDetailReplenishmentProductVo> replenishmentProductList = CrmBeanUtil.copyList(replenishmentProductEntities, TpmAuditDetailReplenishmentProductVo.class);
                Map<String, List<TpmAuditDetailReplenishmentProductVo>> filesMap = replenishmentProductList.stream().filter(o -> StringUtils.isNotEmpty(o.getAuditDetailCode())).collect(Collectors.groupingBy(TpmAuditDetailReplenishmentProductVo::getAuditDetailCode));
                list.forEach(o -> {
                    o.setReplenishmentProductList(filesMap.get(o.getAuditDetailCode()));
                });
            }
        }

        return PageResult.<TpmAuditDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmAuditDetailReqVo reqVo){
        TpmAuditDetailEntity entity = CrmBeanUtil.copy(reqVo,TpmAuditDetailEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmAuditDetailReqVo reqVo){
        TpmAuditDetailEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmAuditDetailEntity> tpmAuditDetailEntities = tpmAuditDetailMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditDetailEntities)){
            tpmAuditDetailEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmAuditDetailEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmAuditDetailEntity> tpmAuditDetailEntities = tpmAuditDetailMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditDetailEntities)){
            tpmAuditDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditDetailEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmAuditDetailEntity> tpmAuditDetailEntities = tpmAuditDetailMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditDetailEntities)){
                tpmAuditDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditDetailEntities);
    }
}
