package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.audit.model.TpmAuditFileEntity;
import com.biz.crm.audit.mapper.TpmAuditFileMapper;
import com.biz.crm.audit.service.ITpmAuditFileService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 核销申请资料表 接口实现
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAuditFileServiceExpandImpl")
public class TpmAuditFileServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAuditFileMapper, TpmAuditFileEntity> implements ITpmAuditFileService {

    @Resource
    private TpmAuditFileMapper tpmAuditFileMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAuditFileRespVo> findList(TpmAuditFileReqVo reqVo){
        Page<TpmAuditFileRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmAuditFileRespVo> list = tpmAuditFileMapper.findList(page, reqVo);
        return PageResult.<TpmAuditFileRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmAuditFileRespVo
     */
    @Override
    public TpmAuditFileRespVo query(TpmAuditFileReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmAuditFileReqVo reqVo){
        TpmAuditFileEntity entity = CrmBeanUtil.copy(reqVo,TpmAuditFileEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmAuditFileReqVo reqVo){
        TpmAuditFileEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmAuditFileEntity> tpmAuditFileEntities = tpmAuditFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditFileEntities)){
            tpmAuditFileEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmAuditFileEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmAuditFileEntity> tpmAuditFileEntities = tpmAuditFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditFileEntities)){
            tpmAuditFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditFileEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmAuditFileEntity> tpmAuditFileEntities = tpmAuditFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditFileEntities)){
                tpmAuditFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditFileEntities);
    }
}
