package com.biz.crm.auditcollectexample.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.auditcollectexample.service.ITpmAuditCollectExampleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 核销采集示例主表
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Slf4j
@RestController
@RequestMapping("/tpmAuditCollectExampleController")
@Api(tags = "核销采集示例主表 ")
public class TpmAuditCollectExampleController {
    @Autowired
    private ITpmAuditCollectExampleService tpmAuditCollectExampleService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAuditCollectExampleRespVo>> list(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        PageResult<TpmAuditCollectExampleRespVo> result = tpmAuditCollectExampleService.findList(tpmAuditCollectExampleReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmAuditCollectExampleRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmAuditCollectExampleRespVo respVo = tpmAuditCollectExampleService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        tpmAuditCollectExampleService.save(tpmAuditCollectExampleReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        tpmAuditCollectExampleService.update(tpmAuditCollectExampleReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmAuditCollectExampleService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmAuditCollectExampleService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmAuditCollectExampleService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
