package com.biz.crm.auditcollectexample.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.auditcollectexample.service.ITpmAuditCollectExamplePictureService;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExamplePictureReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 核销采集示例图片表 
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Slf4j
@RestController
@RequestMapping("/tpmAuditCollectExamplePictureController")
@Api(tags = "核销采集示例图片表 ")
public class TpmAuditCollectExamplePictureController {
    @Autowired
    private ITpmAuditCollectExamplePictureService tpmAuditCollectExamplePictureService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmAuditCollectExamplePictureRespVo>> list(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
        PageResult<TpmAuditCollectExamplePictureRespVo> result=tpmAuditCollectExamplePictureService.findList(tpmAuditCollectExamplePictureReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmAuditCollectExamplePictureRespVo> query(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
        TpmAuditCollectExamplePictureRespVo respVo=tpmAuditCollectExamplePictureService.query(tpmAuditCollectExamplePictureReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
        tpmAuditCollectExamplePictureService.save(tpmAuditCollectExamplePictureReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
        tpmAuditCollectExamplePictureService.update(tpmAuditCollectExamplePictureReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmAuditCollectExamplePictureService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmAuditCollectExamplePictureService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmAuditCollectExamplePictureService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
