package com.biz.crm.auditcollectexample.mapper;

import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import java.util.List;
import java.util.Map;

/**
 * 核销采集示例主表 
 * 
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
public interface TpmAuditCollectExampleMapper extends BaseMapper<TpmAuditCollectExampleEntity> {
    /**
     * 列表
     * @param page
     * @param tpmAuditCollectExampleReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmAuditCollectExampleRespVo> findList(Page<TpmAuditCollectExampleRespVo> page, @Param("vo") TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 删除
     * @param tpmAuditCollectExampleReqVo
     */
    void deleteProductsByParams(@Param("vo")TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);
}
