package com.biz.crm.auditcollectexample.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;




/**
 * 核销采集示例图片表 实体类
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit_collect_example_picture")
@CrmTable(name = "tpm_audit_collect_example_picture",tableNote = "TPM-核销采集示例图片表")
public class TpmAuditCollectExamplePictureEntity extends CrmExtEntity<TpmAuditCollectExamplePictureEntity> {

    /**
     * 示例编码
     */
    @CrmColumn(name = "example_code", length = 32,note = "示例编码")
    private String exampleCode;

    /**
     * 图片地址
     */
    @CrmColumn(name = "url_address", length = 200,note = "图片地址")
    private String urlAddress;

    /**
     * 对象名称
     */
    @CrmColumn(name = "object_name", length = 100,note = "对象名称")
    private String objectName;
}
