package com.biz.crm.auditcollectexample.service;

import com.biz.crm.auditcollectexample.model.TpmAuditCollectExamplePictureEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExamplePictureReqVo;

import java.util.List;
import java.util.Map;

/**
 * 核销采集示例图片表 接口
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
public interface ITpmAuditCollectExamplePictureService extends IService<TpmAuditCollectExamplePictureEntity> {

    /**
     * 列表
     * @param tpmAuditCollectExamplePictureReqVo
     * @return PageResult<TpmAuditCollectExamplePictureRespVo>
     */
    PageResult<TpmAuditCollectExamplePictureRespVo> findList(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 查询
     * @param tpmAuditCollectExamplePictureReqVo
     * @return TpmAuditCollectExamplePictureRespVo
     */
    TpmAuditCollectExamplePictureRespVo query(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 新增
     * @param tpmAuditCollectExamplePictureReqVo
     * @return
     */
    void save(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 更新
     * @param tpmAuditCollectExamplePictureReqVo
     * @return
     */
    void update(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

