package com.biz.crm.auditcollectexample.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.TpmSaveTypeEnum;
import com.biz.crm.exception.tpm.AuditCollectExampleException;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * @Project crm
 * @ClassName AuditCollectExampleServiceHelper
 * @Author HuangLong
 * @Date 2020/9/8 14:02
 * @Description 核销采集表工具类
 */
@Slf4j
@Service
public class AuditCollectExampleServiceHelper {

    @Resource
    private TpmAuditCollectExampleMapper mapper;

    public Map<String, Map<String, String>> getDicts(){
        List<String> dictCodes= Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        dictCodes.add(TpmGlobalDictConstants.EXAMPLE_TYPE);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }

    /**
     * 转换列表数据
     * @param list
     */
    public void convertListDate(List<TpmAuditCollectExampleRespVo> list) {
        if(CollectionUtils.isNotEmpty(list)){
            //获取需要的字典集合
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o->{
                //启用禁用状态
                if(StringUtils.isNotEmpty(o.getEnableStatus())){
                    o.setEnableStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ENABLE_STATUS)).orElse(Maps.newHashMap()).get(o.getEnableStatus()));
                }
                if(StringUtils.isNotEmpty(o.getExampleType())){
                    o.setExampleTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.EXAMPLE_TYPE)).orElse(Maps.newHashMap()).get(o.getExampleType()));
                }
            });
        }
    }
    /**
     * 通过查询条件获取wrapper
     * @return
     */
    public LambdaQueryWrapper<TpmAuditCollectExampleEntity> getQueryWrapper(TpmAuditCollectExampleReqVo reqVo){
        LambdaQueryWrapper<TpmAuditCollectExampleEntity> wrapper = new LambdaQueryWrapper<>();
        //示例名称
        wrapper.like(StringUtils.isNotEmpty(reqVo.getExampleName()),TpmAuditCollectExampleEntity::getExampleName,reqVo.getExampleName());
        //示例编码
        wrapper.like(StringUtils.isNotEmpty(reqVo.getExampleCode()),TpmAuditCollectExampleEntity::getExampleCode,reqVo.getExampleCode());
        //示例类型
        wrapper.eq(StringUtils.isNotEmpty(reqVo.getExampleType()),TpmAuditCollectExampleEntity::getExampleType,reqVo.getExampleType());
        //启用禁用
        wrapper.eq(StringUtils.isNotEmpty(reqVo.getEnableStatus()),TpmAuditCollectExampleEntity::getEnableStatus,reqVo.getEnableStatus());
        return wrapper;
    }
    /**
     * 修改数据(启用,禁用)
     * @param reqVo
     * @param entity
     */
    public void updateBySelectAll(TpmAuditCollectExampleReqVo reqVo,TpmAuditCollectExampleEntity entity){
        LambdaQueryWrapper<TpmAuditCollectExampleEntity> queryWrapper = this.getQueryWrapper(reqVo);
        //TODO  这里必须加上数据权限的限制!!!!
        mapper.update(entity, queryWrapper);
    }
    /**
     * 新增,编辑,校验
     * @param reqVo
     */
    public void saveCheck(TpmAuditCollectExampleReqVo reqVo){
        //校验数据不为空
        if(StringUtils.isEmpty(reqVo.getExampleCode())){
            reqVo.setExampleCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT_COLLECT_EXAMPLE));
        }
        AssertUtils.isNotEmpty(reqVo.getExampleCode(),"请输入示例编码");
        AssertUtils.isNotEmpty(reqVo.getExampleName(),"请输入示例名称");
        AssertUtils.isNotEmpty(reqVo.getExampleType(),"请选择示例类型");
        if(StringUtils.isEmpty(reqVo.getEnableStatus())){
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        AssertUtils.isNotEmpty(reqVo.getEnableStatus(),"请选择启用禁用状态");
        this.checkDataExist(reqVo);
    }

    /**
     * 校验数据是否已经存在
     * @param reqVo
     * @return
     */
    public void checkDataExist(TpmAuditCollectExampleReqVo reqVo ) {
        LambdaQueryWrapper<TpmAuditCollectExampleEntity> wrapper = new LambdaQueryWrapper<TpmAuditCollectExampleEntity>().eq(TpmAuditCollectExampleEntity::getExampleCode,reqVo.getExampleCode());
        if(StringUtils.isNotEmpty(reqVo.getId())){
            wrapper.ne(TpmAuditCollectExampleEntity::getId,reqVo.getId());
        }
        Integer count = mapper.selectCount(wrapper);
        AssertUtils.isTrue(count==0, AuditCollectExampleException.DATA_DUPLICATE);
    }

}
