package com.biz.crm.auditcollectexample.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExamplePictureEntity;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExamplePictureMapper;
import com.biz.crm.auditcollectexample.service.ITpmAuditCollectExamplePictureService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExamplePictureReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 核销采集示例图片表 接口实现
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAuditCollectExamplePictureServiceExpandImpl")
public class TpmAuditCollectExamplePictureServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAuditCollectExamplePictureMapper, TpmAuditCollectExamplePictureEntity> implements ITpmAuditCollectExamplePictureService {

    @Resource
    private TpmAuditCollectExamplePictureMapper tpmAuditCollectExamplePictureMapper;

    /**
     * 列表
     * @param tpmAuditCollectExamplePictureReqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmAuditCollectExamplePictureRespVo> findList(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo){
        Page<TpmAuditCollectExamplePictureRespVo> page = PageUtil.buildPage(tpmAuditCollectExamplePictureReqVo.getPageNum(), tpmAuditCollectExamplePictureReqVo.getPageSize());
        List<TpmAuditCollectExamplePictureRespVo> list = tpmAuditCollectExamplePictureMapper.findList(page, tpmAuditCollectExamplePictureReqVo);
        return PageResult.<TpmAuditCollectExamplePictureRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param tpmAuditCollectExamplePictureReqVo
     * @return tpmAuditCollectExamplePictureRespVo
     */
    @Override
    @CrmLog
    public TpmAuditCollectExamplePictureRespVo query(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo){
        return null;
    }

    /**
     * 新增
     * @param tpmAuditCollectExamplePictureReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo){
        TpmAuditCollectExamplePictureEntity entity = CrmBeanUtil.copy(tpmAuditCollectExamplePictureReqVo,TpmAuditCollectExamplePictureEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param tpmAuditCollectExamplePictureReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo){
        TpmAuditCollectExamplePictureEntity entity = this.getById(tpmAuditCollectExamplePictureReqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids){
        List<TpmAuditCollectExamplePictureEntity> tpmAuditCollectExamplePictureEntities = tpmAuditCollectExamplePictureMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditCollectExamplePictureEntities)){
            tpmAuditCollectExamplePictureEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmAuditCollectExamplePictureEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmAuditCollectExamplePictureEntity> tpmAuditCollectExamplePictureEntities = tpmAuditCollectExamplePictureMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditCollectExamplePictureEntities)){
            tpmAuditCollectExamplePictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditCollectExamplePictureEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmAuditCollectExamplePictureEntity> tpmAuditCollectExamplePictureEntities = tpmAuditCollectExamplePictureMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditCollectExamplePictureEntities)){
                tpmAuditCollectExamplePictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditCollectExamplePictureEntities);
    }
}
