package com.biz.crm.budgetgeneraterule.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.budgetgeneraterule.service.ITpmBudgetGenerateRuleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.budgetgeneraterule.req.TpmBudgetGenerateRuleReqVo;
import com.biz.crm.nebular.tpm.budgetgeneraterule.resp.TpmBudgetGenerateRuleRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 
 *
 * @author gavin
 * @date 2021-12-10 10:32:54
 */
@Slf4j
@RestController
@RequestMapping("/tpmbudgetgeneraterule")
@Api(tags = "费用预算生成规则")
public class TpmBudgetGenerateRuleController {
    @Autowired
    private ITpmBudgetGenerateRuleService tpmBudgetGenerateRuleService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmBudgetGenerateRuleRespVo>> list(@RequestBody TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo) {
        PageResult<TpmBudgetGenerateRuleRespVo> result=tpmBudgetGenerateRuleService.findList(tpmBudgetGenerateRuleReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmBudgetGenerateRuleRespVo> query(@RequestParam("id") String id) {
        TpmBudgetGenerateRuleRespVo respVo=tpmBudgetGenerateRuleService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo) {
        tpmBudgetGenerateRuleService.save(tpmBudgetGenerateRuleReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo) {
        tpmBudgetGenerateRuleService.update(tpmBudgetGenerateRuleReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmBudgetGenerateRuleService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo) {
        tpmBudgetGenerateRuleService.enableBatch(tpmBudgetGenerateRuleReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo) {
        tpmBudgetGenerateRuleService.disableBatch(tpmBudgetGenerateRuleReqVo);
        return Result.ok("禁用成功");
    }

    @ApiOperation(value = "生成费用预算")
    @PostMapping("batchGenerateFeeBudget")
    @CrmLog
    public Result batchGenerateFeeBudget(@RequestBody List<String> ids){
        tpmBudgetGenerateRuleService.batchGenerateFeeBudget(ids);
        return Result.ok("生成费用预算成功");
    }
}
