package com.biz.crm.budgetgeneraterule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 实体类
 *
 * @author gavin
 * @date 2021-12-10 10:32:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_budget_generate_rule")
@CrmTable(name = "tpm_budget_generate_rule", tableNote = "费用预算生成规则表")
public class TpmBudgetGenerateRuleEntity extends CrmExtTenEntity<TpmBudgetGenerateRuleEntity> {


    @CrmColumn(name = "is_generate", length = 1, note = "是否生成费用预算")
    private String isGenerate;

    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 100, note = "门店名称")
    private String terminalName;


    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 60, note = "门店编码")
    private String terminalCode;


    /**
     * 渠道字典值
     */
    @CrmColumn(name = "channel", length = 60, note = "渠道字典值")
    private String channel;


    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 100, note = "客户名称")
    private String customerName;


    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 60, note = "客户编码")
    private String customerCode;


    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "组织名称")
    private String orgName;


    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 60, note = "组织编码")
    private String orgCode;


    /**
     * 比例
     */
    @CrmColumn(name = "ratio", mysqlType = "decimal(10,4)", oracleType = "NUMBER(10,4)", note = "比例")
    private BigDecimal ratio;

    /**
     * 预算生成维度字典编码
     */
    @CrmColumn(name = "fee_budget_type", length = 20, note = "预算生成维度字典编码")
    private String feeBudgetType;

    /**
     * 月份
     */
    @CrmColumn(name = "month", length = 2, note = "月份")
    private String month;


    /**
     * 年度
     */
    @CrmColumn(name = "year", length = 10, note = "年度")
    private String year;


    /**
     * 预算科目名称
     */
    @CrmColumn(name = "budget_subject_name", length = 100, note = "预算科目名称")
    private String budgetSubjectName;


    /**
     * 预算科目编码
     */
    @CrmColumn(name = "budget_subject_code", length = 60, note = "预算科目编码")
    private String budgetSubjectCode;


    /**
     * 预算规则编码
     */
    @CrmColumn(name = "budget_rule_code", length = 60, note = "预算规则编码")
    private String budgetRuleCode;


    /**
     * 预算规则名称
     */
    @CrmColumn(name = "BUDGET_RULE_NAME", length = 100, note = "预算规则名称")
    private String budgetRuleName;

}
