package com.biz.crm.budgetsubjects.mapper;

import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;
import java.util.List;
import java.util.Map;

/**
 * 预算科目 
 * 
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */
public interface TpmBudgetSubjectsMapper extends BaseMapper<TpmBudgetSubjectsEntity> {
    /**
     * 列表
     * @param page
     * @param tpmBudgetSubjectsReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a.create_pos_code",orgCode = "a.create_org_code")
    List<TpmBudgetSubjectsRespVo> findList(Page<TpmBudgetSubjectsRespVo> page, @Param("vo") TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 删除
     * @param tpmBudgetSubjectsReqVo
     */
    void deleteProductsByParams(@Param("vo")TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 统计预算科目被费用预算关联的数量
     * @param ids
     * @return
     */
    List<TpmBudgetSubjectsRespVo> countRelatedNum(@Param("ids")List<String> ids);

}
