package com.biz.crm.costtypecategories.controller;

import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesService;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import com.biz.crm.aop.CrmLog;

import java.util.List;
import java.util.Map;

/**
 * 活动大类 
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@RestController
@RequestMapping("/tpmCostTypeCategoriesController")
@Api(tags = "活动大类 ")
public class TpmCostTypeCategoriesController {
    @Autowired
    private ITpmCostTypeCategoriesService tmpCostTypeCategoriesService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmCostTypeCategoriesRespVo>> list(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        PageResult<TpmCostTypeCategoriesRespVo> result=tmpCostTypeCategoriesService.findList(tpmCostTypeCategoriesReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmCostTypeCategoriesRespVo> query(@RequestParam(value = "id",required = false) String id) {
        TpmCostTypeCategoriesRespVo respVo=tmpCostTypeCategoriesService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        tmpCostTypeCategoriesService.save(tpmCostTypeCategoriesReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        tmpCostTypeCategoriesService.update(tpmCostTypeCategoriesReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tmpCostTypeCategoriesService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tmpCostTypeCategoriesService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tmpCostTypeCategoriesService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 获取所有可用（支持活动）的预算科目
     */
    @ApiOperation(value = "获取所有可用（支持活动）的预算科目")
    @GetMapping("/findAllIsActBudget")
    @CrmLog
    public Result<List<TpmBudgetSubjectsEntity>> findAllIsActBudget(){
        List<TpmBudgetSubjectsEntity> list = tmpCostTypeCategoriesService.findAllIsActBudget();
        return Result.ok(list);
    }

    @ApiOperation(value = "投入类型 选择 客户")
    @PostMapping("/getCusCodes")
    @CrmLog
    public Result<Map<String, MdmCustomerMsgSelectRespVo>> getCusMap(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Map<String, MdmCustomerMsgSelectRespVo> map = tmpCostTypeCategoriesService.getCusMap(mdmCustomerMsgReqVo);
        return Result.ok(map);
    }
}
