package com.biz.crm.costtypecategories.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import com.biz.crm.aop.CrmLog;

import java.util.List;

/**
 * 活动大类范围表;
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@RestController
@RequestMapping("/tpmCostTypeCategoriesRangeController")
@Api(tags = "活动大类范围表;")
public class TpmCostTypeCategoriesRangeController {
    @Autowired
    private ITpmCostTypeCategoriesRangeService tmpCostTypeCategoriesRangeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmCostTypeCategoriesRangeRespVo>> list(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
        PageResult<TpmCostTypeCategoriesRangeRespVo> result=tmpCostTypeCategoriesRangeService.findList(tpmCostTypeCategoriesRangeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmCostTypeCategoriesRangeRespVo> query(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
        TpmCostTypeCategoriesRangeRespVo respVo=tmpCostTypeCategoriesRangeService.query(tpmCostTypeCategoriesRangeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
        tmpCostTypeCategoriesRangeService.save(tpmCostTypeCategoriesRangeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmCostTypeCategoriesRangeReqVo tpmCostTypeCategoriesRangeReqVo) {
        tmpCostTypeCategoriesRangeService.update(tpmCostTypeCategoriesRangeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tmpCostTypeCategoriesRangeService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tmpCostTypeCategoriesRangeService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tmpCostTypeCategoriesRangeService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
