package com.biz.crm.costtypecategories.mapper;

import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.DataPermission;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import java.util.List;

/**
 * 活动大类 
 * 
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
public interface TpmCostTypeCategoriesMapper extends BaseMapper<TpmCostTypeCategoriesEntity> {
    /**
     * 列表
     * @param page
     * @param tpmCostTypeCategoriesReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a.create_pos_code",orgCode = "a.create_org_code")
    List<TpmCostTypeCategoriesRespVo> findList(Page<TpmCostTypeCategoriesRespVo> page, @Param("vo") TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 删除
     * @param tpmCostTypeCategoriesReqVo
     */
    void deleteByParams(@Param("vo") TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 启用,禁用
     * @param entity
     * @param reqVo
     */
    void updateBySelectAll(@Param("entity") TpmCostTypeCategoriesEntity entity, @Param("vo") TpmCostTypeCategoriesReqVo reqVo);

    /**
     * 根据活动大类查询活动中使用了的大类
     * @param reqVo
     * @return
     */
    List<String> findActByParams(@Param("vo")TpmCostTypeCategoriesReqVo reqVo);

    /**
     * 活动新增根据选定的费用预算维度查询活动大类
     * @param reqVo
     * @return
     */
    List<TpmCostTypeCategoriesRespVo> getCategoriesByBudget(@Param("vo")ActGetCategoriesByBudgetReqVo reqVo);

    /**
     * 根据投入类型查询预算科目信息
     * @param categoriesCodes
     * @return
     */
    List<TpmCostTypeCategoriesRespVo> getCategoriesSubjectInfo(@Param("categoriesCodes") List<String> categoriesCodes);
}
