package com.biz.crm.costtypecategories.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 活动大类与活动细类的关联表 实体类
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_cost_type_categories_fine")
@CrmTable(name = "tpm_cost_type_categories_fine",tableNote = "TPM-活动大类与活动细类的关联表")
public class TpmCostTypeCategoriesFineEntity extends CrmExtEntity<TpmCostTypeCategoriesFineEntity> {

    /**
     * 活动大类编码
     */
    @CrmColumn(name = "categories_code", length = 32,note = "活动大类编码")
    private String categoriesCode;

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;


}
