package com.biz.crm.costtypecategories.service;

import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesFineRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;

import java.util.List;
import java.util.Map;

/**
 * 活动大类与活动细类的关联表 接口
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
public interface ITpmCostTypeCategoriesFineService extends IService<TpmCostTypeCategoriesFineEntity> {

    /**
     * 列表
     * @param tpmCostTypeCategoriesFineReqVo
     * @return PageResult<TpmCostTypeCategoriesFineRespVo>
     */
    PageResult<TpmCostTypeCategoriesFineRespVo> findList(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 查询
     * @param tpmCostTypeCategoriesFineReqVo
     * @return TpmCostTypeCategoriesFineRespVo
     */
    TpmCostTypeCategoriesFineRespVo query(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 新增
     * @param tpmCostTypeCategoriesFineReqVo
     * @return
     */
    void save(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 更新
     * @param tpmCostTypeCategoriesFineReqVo
     * @return
     */
    void update(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

