package com.biz.crm.costtypecategories.service;

import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;

import java.util.List;
import java.util.Map;

/**
 * 活动大类 接口
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
public interface ITpmCostTypeCategoriesService extends IService<TpmCostTypeCategoriesEntity> {

    /**
     * 列表
     * @param tpmCostTypeCategoriesReqVo
     * @return PageResult<TpmCostTypeCategoriesRespVo>
     */
    PageResult<TpmCostTypeCategoriesRespVo> findList(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 查询
     * @param id
     * @return TpmCostTypeCategoriesRespVo
     */
    TpmCostTypeCategoriesRespVo query(String id);

    /**
     * 新增
     * @param tpmCostTypeCategoriesReqVo
     * @return
     */
    void save(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 更新
     * @param tpmCostTypeCategoriesReqVo
     * @return
     */
    void update(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 活动新增根据选定的费用预算维度查询活动大类
     * @param reqVo
     * @return
     */
    List<TpmCostTypeCategoriesRespVo> getCategoriesByBudget(ActGetCategoriesByBudgetReqVo reqVo);

    /**
     * 获取所有可用（支持活动）的预算科目
     * @return
     */
    List<TpmBudgetSubjectsEntity> findAllIsActBudget();

    /**
     * 主数据中心的
     * @param mdmCustomerMsgReqVo
     * @return
     */
    Map<String, MdmCustomerMsgSelectRespVo> getCusMap(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);


    /**
     * 根据投入类型查询费用科目信息
     * @param categoriesCodes
     * @return
     */
    List<TpmCostTypeCategoriesRespVo> getCategoriesSubjectInfo(List<String> categoriesCodes);
}

