package com.biz.crm.costtypecategories.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesRangeEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesService;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.tpm.CostTypeCategoriesException;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.tableconfig.MdmFunctionSubFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesFineRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动大类 接口实现
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "TmpCostTypeCategoriesServiceExpandImpl")
public class TpmCostTypeCategoriesServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<TpmCostTypeCategoriesMapper, TpmCostTypeCategoriesEntity> implements ITpmCostTypeCategoriesService {

    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Autowired
    private CostTypeCategoriesServiceHelper serviceHelper;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper fineMapper;
    @Resource
    private MdmFunctionSubFeign mdmFunctionSubFeign;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;



    /**
     * 列表
     *
     * @param tpmCostTypeCategoriesReqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmCostTypeCategoriesRespVo> findList(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
        Page<TpmCostTypeCategoriesRespVo> page = PageUtil.buildPage(tpmCostTypeCategoriesReqVo.getPageNum(), tpmCostTypeCategoriesReqVo.getPageSize());
        tpmCostTypeCategoriesReqVo.setSelectedCodeList(serviceHelper.dealSelectedCodeList(tpmCostTypeCategoriesReqVo.getSelectedCode(),tpmCostTypeCategoriesReqVo.getSelectedCodeList()));
        List<TpmCostTypeCategoriesRespVo> list = tpmCostTypeCategoriesMapper.findList(page, tpmCostTypeCategoriesReqVo);
        serviceHelper.convertListDate(list);
        return PageResult.<TpmCostTypeCategoriesRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param id
     * @return tmpCostTypeCategoriesRespVo
     */
    @Override
    @CrmLog
    public TpmCostTypeCategoriesRespVo query(String id) {
        AssertUtils.isNotEmpty(id, "id不能为空");
        TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo = new TpmCostTypeCategoriesReqVo();
        tpmCostTypeCategoriesReqVo.setId(id);
        List<TpmCostTypeCategoriesRespVo> list = this.findList(tpmCostTypeCategoriesReqVo).getData();
        if (CollectionUtils.isEmpty(list)) {
//            throw new BusinessException(CostTypeCategoriesException.DATA_NOT_EXIST);
            return new TpmCostTypeCategoriesRespVo();
        }
        TpmCostTypeCategoriesRespVo respVo = list.get(0);
        //关联财务科目，为财务科目名称赋值
        if (StringUtils.isNotEmpty(respVo.getFinanceSubjectCode())) {
            TpmFinanceSubjectEntity tpmFinanceSubjectEntity = financeSubjectMapper.selectOne(Wrappers.lambdaQuery(TpmFinanceSubjectEntity.class).eq(TpmFinanceSubjectEntity::getFinanceSubjectCode, respVo.getFinanceSubjectCode()));
            if (tpmFinanceSubjectEntity != null) {
                respVo.setFinanceSubjectName(tpmFinanceSubjectEntity.getFinanceSubjectName());
            }
        }
        //查询范围信息
        TpmCostTypeCategoriesRangeReqVo rangeReqVo = new TpmCostTypeCategoriesRangeReqVo();
        rangeReqVo.setPageSize(-1);
        rangeReqVo.setCategoriesCode(respVo.getCategoriesCode());
        List<TpmCostTypeCategoriesRangeRespVo> rangeVos = rangeService.findList(rangeReqVo).getData();
        //把范围信息按照组织,组织类型,包含非包含做拆分
        Map<String, List<TpmCostTypeCategoriesRangeRespVo>> map = rangeVos.stream().collect(Collectors.groupingBy(o -> o.getRangeType() + o.getIsContain()));
        map.keySet().forEach(o -> {
            List<TpmCostTypeCategoriesRangeRespVo> vos = map.get(o);
            if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG + TpmGlobalDictConstants.CONTAIN, o)) {
                //组织包含
                respVo.setContainOrgRangeVos(vos);
            } else if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG + TpmGlobalDictConstants.NON_CONTAIN, o)) {
                //组织非包含
                respVo.setNonContainOrgRangeVos(vos);
            } else if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG_TYPE + TpmGlobalDictConstants.CONTAIN, o)) {
                //组织类型包含
                respVo.setContainOrgTypeRangeVos(vos);
            } else if (StringUtils.equals(TpmGlobalDictConstants.RANGE_ORG_TYPE + TpmGlobalDictConstants.NON_CONTAIN, o)) {
                respVo.setNonContainOrgTypeRangeVos(vos);
            } else {
                throw new BusinessException("活动大类" + respVo.getCategoriesCode() + "范围信息数据异常");
            }
        });
        //查询关联细类数据
        TpmCostTypeCategoriesFineReqVo fineReqVo = new TpmCostTypeCategoriesFineReqVo();
        fineReqVo.setPageSize(-1);
        fineReqVo.setCategoriesCode(respVo.getCategoriesCode());
        List<TpmCostTypeCategoriesFineRespVo> fineVos = fineService.findList(fineReqVo).getData();
        respVo.setFineVos(fineVos);
        //查询关联表单信息
        if (StringUtils.isNotEmpty(respVo.getFormCode())) {
            Result<MdmFunctionSubRespVo> respVoResult = mdmFunctionSubFeign.query(new MdmFunctionSubReqVo().setFunctionCode(respVo.getFormCode()));
            if (ObjectUtils.isNotEmpty(respVoResult.getResult())) {
                respVo.setFormName(respVoResult.getResult().getFunctionName());
            }
        }
        return respVo;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(TpmCostTypeCategoriesReqVo reqVo) {
        serviceHelper.saveCheck(reqVo);
        TpmCostTypeCategoriesEntity entity = CrmBeanUtil.copy(reqVo, TpmCostTypeCategoriesEntity.class);
        this.save(entity);
        //保存范围数据
        serviceHelper.saveRanges(reqVo);
        //保存关联细类数据
        serviceHelper.saveFines(reqVo);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmCostTypeCategoriesRespVo newData = CrmBeanUtil.copy(entity, TpmCostTypeCategoriesRespVo.class);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getCategoriesCode(), newData);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getId())) {
            throw new BusinessException("数据主键不能为空");
        }
        TpmCostTypeCategoriesEntity entity = this.getById(reqVo.getId());
        AssertUtils.isNotNull(entity, CostTypeCategoriesException.DATA_NOT_EXIST);
        serviceHelper.saveCheck(reqVo);
        //日志老数据
        TpmCostTypeCategoriesRespVo oldData = CrmBeanUtil.copy(entity, TpmCostTypeCategoriesRespVo.class);
        CrmBeanUtil.copyProperties(reqVo, entity);
        this.updateById(entity);
        //酒类的投入类型不走下面的代码,因为会删掉关联关系
        if (!StringUtils.equals(TpmProjectNameEnum.LIQUEUR_TPM.getCode(), reqVo.getTpmProjectName())) {
            //更新范围数据
            serviceHelper.saveRanges(reqVo);
            //更新细类数据
            serviceHelper.saveFines(reqVo);
        }
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmCostTypeCategoriesRespVo newData = CrmBeanUtil.copy(entity, TpmCostTypeCategoriesRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getCategoriesCode(), oldData, newData);

    }

    /**
     * 删除
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids) {
        //如果活动使用了大类,大类数据不能被删除
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo = new TpmCostTypeCategoriesReqVo().setIds(ids);
        serviceHelper.deleteCheck(tpmCostTypeCategoriesReqVo);
        //日志老数据
        PageResult<TpmCostTypeCategoriesRespVo> oldDatList = this.findList(tpmCostTypeCategoriesReqVo);
        List<TpmCostTypeCategoriesRespVo> list = oldDatList.getData();
        if(CollectionUtils.isNotEmpty(list)){
            tpmCostTypeCategoriesMapper.deleteBatchIds(ids);
            List<String> codes = list.stream().map(TpmCostTypeCategoriesRespVo::getCategoriesCode).collect(Collectors.toList());
            fineMapper.delete(Wrappers.lambdaQuery(TpmCostTypeCategoriesFineEntity.class).in(TpmCostTypeCategoriesFineEntity::getCategoriesCode,codes));
            rangeMapper.delete(Wrappers.lambdaQuery(TpmCostTypeCategoriesRangeEntity.class).in(TpmCostTypeCategoriesRangeEntity::getCategoriesCode,codes));
            //日志
            Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            oldDatList.getData().stream().forEach(o -> {
                crmLogSendUtil.sendForDel(menuCodeObj.toString(), o.getId(), o.getCategoriesCode(), o);
            });
        }
    }

    /**
     * 启用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids) {
        //设置状态为启用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmCostTypeCategoriesEntity> entities = tpmCostTypeCategoriesMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmCostTypeCategoriesRespVo> oldDataList = CrmBeanUtil.copyList(entities, TpmCostTypeCategoriesRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        //日志
        List<TpmCostTypeCategoriesRespVo> newDataList = CrmBeanUtil.copyList(entities, TpmCostTypeCategoriesRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (int i = 0; i < newDataList.size(); i++) {
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newDataList.get(i).getId(), newDataList.get(i).getCategoriesCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    /**
     * 禁用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmCostTypeCategoriesEntity> entities = tpmCostTypeCategoriesMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmCostTypeCategoriesRespVo> oldDataList = CrmBeanUtil.copyList(entities, TpmCostTypeCategoriesRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmCostTypeCategoriesRespVo> newDataList = CrmBeanUtil.copyList(entities, TpmCostTypeCategoriesRespVo.class);
        for (int i = 0; i < newDataList.size(); i++) {
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newDataList.get(i).getId(), newDataList.get(i).getCategoriesCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    /**
     * 活动新增根据选定的费用预算维度查询活动大类
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<TpmCostTypeCategoriesRespVo> getCategoriesByBudget(ActGetCategoriesByBudgetReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getControlIds(), "费用预算控制维度id集合不能为空");
        AssertUtils.isNotEmpty(reqVo.getActType(), "活动类型不能为空");
        //获取当前登录人对应的企业组织
        UserRedis user = UserUtils.getUser();
//        log.info("当前登录人信息={}", JSON.toJSONString(user));
        if (Objects.nonNull(user)) {
//            AssertUtils.isTrue(StringUtils.isEmpty(user.getOrgcode())|| Objects.isNull(user.getType()),"当前登录人组织信息不完整");
            List<String> rangeCodes = Lists.newArrayList();
            //由于组织类型和组织的编码本身就不一样,所以直接放到集合去匹配范围就行了
            if (StringUtils.isNotEmpty(user.getOrgcode())) {
                rangeCodes.add(user.getOrgcode());
                MdmOrgRespVo orgByCode = OrgUtil.getOrgByCode(user.getOrgcode());
                AssertUtils.isNotNull(orgByCode, "当前用户的组织不存在");
                if (StringUtils.isNotEmpty(orgByCode.getOrgType())) {
                    rangeCodes.add(orgByCode.getOrgType());
                }
            }
            reqVo.setRangeCodes(rangeCodes);
        }
        //通过控制维度获取到预算科目,再用预算科目查活动大类

        //目前产品组开发的活动大类的范围信息只有包含的信息,并且是否当前组织及下级组织的值不用管,默认是当前组织
//        log.info("活动新增根据选定的费用预算维度查询活动大类,请求参数={}", JSON.toJSONString(reqVo));
        List<TpmCostTypeCategoriesRespVo> respVos = tpmCostTypeCategoriesMapper.getCategoriesByBudget(reqVo);
        //去重
        if (CollectionUtils.isNotEmpty(respVos)) {
            respVos = respVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(TpmCostTypeCategoriesRespVo::getId))), ArrayList::new));
        }
        return respVos;
    }

    /**
     * 查询所有可用的预算科目（支持活动）
     *
     * @return
     */
    @Override
    public List<TpmBudgetSubjectsEntity> findAllIsActBudget() {
        LambdaQueryWrapper<TpmBudgetSubjectsEntity> wrapper = Wrappers.<TpmBudgetSubjectsEntity>lambdaQuery()
                .eq(TpmBudgetSubjectsEntity::getIsActBudget, GlobalWhetherEnum.YES.getCode());
        wrapper.eq(TpmBudgetSubjectsEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode());
        wrapper.eq(TpmBudgetSubjectsEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode());
        List<TpmBudgetSubjectsEntity> list = budgetSubjectsMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public Map<String, MdmCustomerMsgSelectRespVo> getCusMap(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgReqVo reqVo = new MdmCustomerMsgReqVo();
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        Result<List<MdmCustomerMsgSelectRespVo>> result = null;
        try {
            result = mdmCustomerMsgFeign.findCustomerSelectList(reqVo);
        } catch (Exception e) {
            log.error("{}", e);
            throw new BusinessException("大类新增获取客户,调用mdm接口失败");
        }
        List<MdmCustomerMsgSelectRespVo> list = ApiResultUtil.objResult(result, true);
        Map<String, MdmCustomerMsgSelectRespVo> map = list.stream().collect(Collectors.toMap(MdmCustomerMsgSelectRespVo::getCustomerCode, Function.identity(), (k1, k2) -> k1));
        return map;
    }

    @Override
    public List<TpmCostTypeCategoriesRespVo> getCategoriesSubjectInfo(List<String> categoriesCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(categoriesCodes)) {
            return tpmCostTypeCategoriesMapper.getCategoriesSubjectInfo(categoriesCodes);
        } else {
            return null;
        }
    }
}
