package com.biz.crm.costtypefine.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动细类
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
@Slf4j
@RestController
@RequestMapping("/tpmCostTypeFineController")
@Api(tags = "活动细类")
public class TpmCostTypeFineController {

    @Autowired
    private ITpmCostTypeFineService tpmCostTypeFineService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmCostTypeFineRespVo>> list(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
        PageResult<TpmCostTypeFineRespVo> result = tpmCostTypeFineService.findList(tpmCostTypeFineReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmCostTypeFineRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmCostTypeFineRespVo respVo = tpmCostTypeFineService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
        tpmCostTypeFineService.save(tpmCostTypeFineReqVo);
        return Result.ok("新增成功");
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
        tpmCostTypeFineService.update(tpmCostTypeFineReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmCostTypeFineService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmCostTypeFineService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmCostTypeFineService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    @ApiOperation(value = "活动细类,根据细类编码查询细类关联的活动大类集合")
    @PostMapping("/findCategoriesByFineCode")
    @CrmLog
    public Result<PageResult<TpmCostTypeCategoriesRespVo>> findCategoriesByFineCode(@RequestBody TpmCostTypeFineReqVo reqVo) {
        PageResult<TpmCostTypeCategoriesRespVo> result = tpmCostTypeFineService.findCategoriesByFineCode(reqVo);
        return Result.ok(result);
    }


}
