package com.biz.crm.costtypefine.mapper;

import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import java.util.List;
import java.util.Map;

/**
 * 活动细类 
 * 
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
public interface TpmCostTypeFineMapper extends BaseMapper<TpmCostTypeFineEntity> {
    /**
     * 列表
     * @param page
     * @param tpmCostTypeFineReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmCostTypeFineRespVo> findList(Page<TpmCostTypeFineRespVo> page, @Param("vo") TpmCostTypeFineReqVo tpmCostTypeFineReqVo);

    /**
     * 删除,根据条件删除
     * @param reqVo
     */
    void deleteProductsByParams(@Param("vo")TpmCostTypeFineReqVo reqVo);

    /**
     * 活动细类,根据细类编码查询细类关联的活动大类集合
     * @param reqVo
     * @return
     */
    List<TpmCostTypeCategoriesRespVo> findCategoriesByFineCode(Page<TpmCostTypeCategoriesRespVo> page,@Param("vo")TpmCostTypeFineReqVo reqVo);

    /**
     * 酒类活动管理下拉选择活动类型
     * @param reqVo
     * @return
     */
    List<TpmCostTypeFineRespVo> liqueurGetFineList(@Param("vo") ActGetCategoriesByBudgetReqVo reqVo);
}
