package com.biz.crm.costtypefine.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动采集字段表与活动细类的关联表;实体类
 *
 * @author zeyi
 * @date 2020-11-04 13:59:17
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_act_collect_field_fine")
@CrmTable(name = "tpm_act_collect_field_fine",tableNote = "TPM-活动采集字段表与活动细类的关联表")
public class TpmActCollectFieldFineEntity extends CrmExtEntity<TpmActCollectFieldFineEntity> {

    /**
     * 活动采集字段编码
     */
    @CrmColumn(name = "field_code", length = 32,note = "活动采集字段编码")
    private String fieldCode;

    /**
     * 活动采集字段名称
     */
    @CrmColumn(name = "field_name", length = 60,note = "活动采集字段名称")
    private String fieldName;

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;

    /**
     * 是否必填(Y/N)
     */
    @CrmColumn(name = "whether_required", length = 32,note = "是否必填(Y/N)")
    private String whetherRequired;

    /**
     * 显示顺序
     */
    @CrmColumn(name = "display_order", length = 32,note = "是否必填(Y/N)")
    private String displayOrder;

    /**
     * 默认值
     */
    @CrmColumn(name = "defaults", length = 60,note = "默认值")
    private String defaults;

    /**
     * 提示语
     */
    @CrmColumn(name = "hint", length = 60,note = "默认值")
    private String hint;

}
