package com.biz.crm.costtypefine.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesRangeEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mysql.cj.xdevapi.Collection;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Project crm
 * @ClassName CostTypeFineServiceHelper
 * @Author HuangLong
 * @Date 2020/9/8 14:02
 * @Description 活动细类工具类
 */
@Slf4j
@Service
public class CostTypeFineServiceHelper extends BaseServiceHelper {

    @Resource
    private TpmCostTypeFineMapper mapper;
    @Resource
    private TpmAuditCollectExampleMapper exampleMapper;

    @Resource
    private TpmCostTypeCategoriesFineMapper fineMapper;

    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;

    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;

    public Map<String, Map<String, String>> getDicts() {
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        dictCodes.add(TpmGlobalDictConstants.ACTIVITY_RELEASE_NEED);
        dictCodes.add(TpmGlobalDictConstants.ACTIVITY_TYPE);
        dictCodes.add(TpmGlobalDictConstants.PAYMENT_METHOD);
//        dictCodes.add(TpmGlobalDictConstants.PAY_TYPE);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }

    /**
     * 转换列表数据
     *
     * @param list
     */
    public void convertListDate(List<TpmCostTypeFineRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            //获取需要的字典集合
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                //启用禁用状态
                if (StringUtils.isNotEmpty(o.getEnableStatus())) {
                    o.setEnableStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ENABLE_STATUS)).orElse(Maps.newHashMap()).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty(o.getActivityReleaseNeed())) {
                    o.setActivityReleaseNeedName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ACTIVITY_RELEASE_NEED)).orElse(Maps.newHashMap()).get(o.getActivityReleaseNeed()));
                }
                if (StringUtils.isNotEmpty(o.getActivityType())) {
                    o.setActivityTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ACTIVITY_TYPE)).orElse(Maps.newHashMap()).get(o.getActivityType()));
                }
                if (StringUtils.isNotEmpty(o.getPayTypeList())) {
                    o.setPayTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.PAY_TYPE)).orElse(Maps.newHashMap()).get(o.getPayTypeList()));
                }
                //转义是否核销
                o.setIsAuditEsc(GlobalWhetherEnum.getDesByCode(o.getIsAudit()));
                //转义是否推送SFA
                o.setIsSendSfaEsc(GlobalWhetherEnum.getDesByCode(o.getIsSendSfa()));
                //转义是否审核活动细明、
                o.setIsReviewActivityDetailsEsc(GlobalWhetherEnum.getDesByCode(o.getIsReviewActivityDetails()));
                //转义是否跨组织占用预算
                o.setIsSpanOrgBudgetEsc(GlobalWhetherEnum.getDesByCode(o.getIsSpanOrgBudget()));
                o.setIsCollectActDataDesc(GlobalWhetherEnum.getDesByCode(o.getIsCollectActData()));
                o.setIsCollectDistributionOrderDesc(GlobalWhetherEnum.getDesByCode(o.getIsCollectDistributionOrder()));
                o.setIsSignDisplayAgreementDesc(GlobalWhetherEnum.getDesByCode(o.getIsSignDisplayAgreement()));
                o.setIsControlActFeeDesc(GlobalWhetherEnum.getDesByCode(o.getIsControlActFee()));

                if (StringUtils.isNotEmpty(o.getPaymentMethod())) {
                    o.setPaymentMethodDesc(Optional.ofNullable(map.get(TpmGlobalDictConstants.PAYMENT_METHOD)).orElse(Maps.newHashMap()).get(o.getPaymentMethod()));
                }

            });
        }
    }

    /**
     * 通过查询条件获取wrapper
     *
     * @return
     */
    public LambdaQueryWrapper<TpmCostTypeFineEntity> getQueryWrapper(TpmCostTypeFineReqVo reqVo) {
        LambdaQueryWrapper<TpmCostTypeFineEntity> wrapper = new LambdaQueryWrapper<>();
        //细类编码
        wrapper.like(StringUtils.isNotEmpty(reqVo.getFineCode()), TpmCostTypeFineEntity::getFineCode, reqVo.getFineCode());
        //细类名称
        wrapper.like(StringUtils.isNotEmpty(reqVo.getFineName()), TpmCostTypeFineEntity::getFineName, reqVo.getFineName());
        //启用禁用
        wrapper.eq(StringUtils.isNotEmpty(reqVo.getEnableStatus()), TpmCostTypeFineEntity::getEnableStatus, reqVo.getEnableStatus());
        return wrapper;
    }

    /**
     * 修改数据(启用,禁用)
     *
     * @param reqVo
     * @param entity
     */
    public void updateBySelectAll(TpmCostTypeFineReqVo reqVo, TpmCostTypeFineEntity entity) {
        LambdaQueryWrapper<TpmCostTypeFineEntity> queryWrapper = this.getQueryWrapper(reqVo);
        //TODO  这里必须加上数据权限的限制!!!!
        mapper.update(entity, queryWrapper);
    }

    /**
     * 新增,编辑,校验
     *
     * @param reqVo
     */
    public void saveCheck(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.isNotEmpty(reqVo.getTpmProjectName()) && TpmProjectNameEnum.LIQUEUR_TPM.getCode().equals(reqVo.getTpmProjectName())) {
            this.saveCheckLiqueurTpm(reqVo);
        } else {
            this.saveCheckBaseTpm(reqVo);
        }

    }

    /**
     * 校验数据是否已经存在
     *
     * @param reqVo
     * @return
     */
    public void checkDataExist(TpmCostTypeFineReqVo reqVo) {
        LambdaQueryWrapper<TpmCostTypeFineEntity> wrapper = new LambdaQueryWrapper<TpmCostTypeFineEntity>().eq(TpmCostTypeFineEntity::getFineCode, reqVo.getFineCode());
        if (StringUtils.isNotEmpty(reqVo.getId())) {
            wrapper.ne(TpmCostTypeFineEntity::getId, reqVo.getId());
        }
        Integer count = mapper.selectCount(wrapper);
        AssertUtils.isTrue(count==0, CostTypeFineException.DATA_CODE_DUPLICATE);
    }

    /**
     * 根据采集要求和核销资料要求的集合获取数据
     *
     * @param listJson
     * @return
     */
    public List<TpmAuditCollectExampleRespVo> getExamples(String listJson) {
        List<String> codes = JSON.parseArray(listJson, String.class);
        if(CollectionUtils.isEmpty(codes)){
            return new ArrayList<>();
        }
        LambdaQueryWrapper<TpmAuditCollectExampleEntity> queryWrapper = new LambdaQueryWrapper<TpmAuditCollectExampleEntity>().in(TpmAuditCollectExampleEntity::getExampleCode, codes);
        return exampleMapper.selectList(queryWrapper).stream().filter(Objects::nonNull).map(o -> {
            TpmAuditCollectExampleRespVo vo = new TpmAuditCollectExampleRespVo();
            vo.setExampleCode(o.getExampleCode());
            vo.setExampleName(o.getExampleName());
            return vo;
        }).collect(Collectors.toList());
    }

    /**
     * 通过支付方式字典编码Json获取支付方式集合
     *
     * @param payTypeList
     * @return
     */
    public List<DictItemVo> getPayTypes(String payTypeList) {
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.PAY_TYPE);
        //查询字典数据
        Map<String, Map<String, String>> dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes(dictCodes);
        Map<String, String> map = Optional.ofNullable(dictValueMapsByCodes.get(TpmGlobalDictConstants.PAY_TYPE)).orElse(Maps.newHashMap());
        List<String> codes = JSON.parseArray(payTypeList, String.class);
        List<DictItemVo> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(codes)) {
            codes.forEach(o -> {
                DictItemVo dictItemVo = new DictItemVo();
                String s = map.get(o);
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(o);
                list.add(dictItemVo);
            });
        }
        return list;
    }


    /**
     * 默认tpm校验
     */
    private void saveCheckBaseTpm(TpmCostTypeFineReqVo reqVo) {
        //校验数据不为空
        if (StringUtils.isEmpty(reqVo.getFineCode())) {
            reqVo.setFineCode(CodeUtil.createOneCode(CrmCodeRuleConstants.COST_TYPE_FINE));
        }
        if (reqVo.getAuditValidity()!=null){
            AssertUtils.isTrue(reqVo.getAuditValidity()>0,"核销有效期(月)必须大于0");
        }
        if (reqVo.getExtraAuditRatio() != null){
            AssertUtils.isTrue(reqVo.getExtraAuditRatio().compareTo(BigDecimal.ZERO)!=-1,"超额核销比例必须大于等于0");
        }
        AssertUtils.isNotEmpty(reqVo.getFineCode(), "活动细类编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getFineName(), "请输入活动细类名称");
        if(!StringUtils.equals(GlobalWhetherEnum.YES.getCode(),reqVo.getIsSignDisplayAgreement())){
            reqVo.setPaymentMethod(null);
        }
        super.isJsonArray(reqVo.getPayTypeList(), "支付方式必须是数组格式的json字符串");
        super.isJsonArray(reqVo.getCollectRequireList(), "采集要求必须是数组格式的json字符串");
        super.isJsonArray(reqVo.getAuditRequireList(), "核销资料要求必须是数组格式的json字符串");
        if (StringUtils.isEmpty(reqVo.getIsAudit())) {
            reqVo.setIsAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.equals(GlobalWhetherEnum.YES.getCode(), reqVo.getIsAudit())) {
            //如果选择了需要核销,是否自动核销和是否允许多次核销都必须选择
            if (StringUtils.isEmpty(reqVo.getIsAutoAudit())) {
                reqVo.setIsAutoAudit(GlobalWhetherEnum.NO.getCode());
            }
        }
        if (StringUtils.isEmpty(reqVo.getIsAllowRepeatAudit())) {
            reqVo.setIsAllowRepeatAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty(reqVo.getEnableStatus())) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        if (StringUtils.isEmpty(reqVo.getIsSendSfa())) {
            reqVo.setIsSendSfa(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty(reqVo.getIsShareToProduct())) {
            reqVo.setIsShareToProduct(GlobalWhetherEnum.NO.getCode());
        }
        this.checkDataExist(reqVo);
    }

    /**
     * 酒类tpm校验
     */
    private void saveCheckLiqueurTpm(TpmCostTypeFineReqVo reqVo) {
        //校验数据不为空
        if (StringUtils.isEmpty(reqVo.getFineCode())) {
            reqVo.setFineCode(CodeUtil.createOneCode(CrmCodeRuleConstants.COST_TYPE_FINE));
        }
        if (reqVo.getAuditValidity() != null){
            AssertUtils.isTrue(reqVo.getAuditValidity()>0,"核销有效期必须大于0");
        }
        if (reqVo.getExtraAuditRatio() != null){
            AssertUtils.isTrue(reqVo.getExtraAuditRatio().compareTo(BigDecimal.ZERO)!=-1,"超额核销比例必须大于等于0");
        }
        if(!StringUtils.equals(GlobalWhetherEnum.YES.getCode(),reqVo.getIsSignDisplayAgreement())){
            reqVo.setPaymentMethod(null);
        }
        AssertUtils.isNotEmpty(reqVo.getFineCode(), "活动细类编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getFineName(), "请输入活动细类名称");
//        AssertUtils.isNotEmpty(reqVo.getCostFormCode(), "请选择活动类型表单");
//        AssertUtils.isNotEmpty(reqVo.getIsSpanOrgBudget(),"请确认是否跨组织占用预算");
//        AssertUtils.isNotEmpty(reqVo.getCostFormCode(),"请确认活动明细表单");
//        AssertUtils.isNotEmpty(reqVo.getAuditFormCode(),"请确认活动核销表单");
//        AssertUtils.isNotEmpty(reqVo.getIsSendSfa(), "请确认是否推送SFA");
//        AssertUtils.isNotEmpty(reqVo.getIsNeedCollectData(), "请确认是否需要采集资料");
        if(StringUtils.isEmpty(reqVo.getIsAudit())){
            reqVo.setIsAudit(GlobalWhetherEnum.YES.getCode());
        }
        if (StringUtils.isEmpty(reqVo.getIsNeedAuditData())){
            reqVo.setIsNeedAuditData(GlobalWhetherEnum.YES.getCode());
        }
        //如果选择了需要核销,是否自动核销和是否允许多次核销都必须选择
        if (StringUtils.isEmpty(reqVo.getIsAutoAudit())) {
            reqVo.setIsAutoAudit(GlobalWhetherEnum.NO.getCode());
        }
//        AssertUtils.isTrue(CollectionUtil.listNotEmptyNotSizeZero(reqVo.getTpmCostTypeCategoriesFineReqVo()),"请选择投入类型进行关联");
        if (StringUtils.isEmpty(reqVo.getIsAutoAudit())) {
            reqVo.setIsAutoAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty(reqVo.getEnableStatus())) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        //校验范围信息
        List<TpmCostTypeCategoriesRangeReqVo> rangeVos = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(reqVo.getContainOrgRangeVos())){
            rangeVos.addAll(reqVo.getContainOrgRangeVos());
        }
        if(CollectionUtils.isNotEmpty(reqVo.getNonContainOrgRangeVos())){
            rangeVos.addAll(reqVo.getNonContainOrgRangeVos());
        }
        if(CollectionUtils.isNotEmpty(reqVo.getContainOrgTypeRangeVos())){
            rangeVos.addAll(reqVo.getContainOrgTypeRangeVos());
        }
        if(CollectionUtils.isNotEmpty(reqVo.getNonContainOrgTypeRangeVos())){
            rangeVos.addAll(reqVo.getNonContainOrgTypeRangeVos());
        }
        //校验费包含和包含数据里面的组织范围仅当前组织属性是否为空
        if(CollectionUtils.isNotEmpty(rangeVos)){
            Set<String> rangeSet=Sets.newHashSet();
            rangeVos.stream().forEach(o->{
                AssertUtils.isNotNull(o.getRangeType(),"范围类型不能为空");
                AssertUtils.isNotNull(o.getRangeCode(),"范围编码不能为空");
                if(Objects.equals(1,o.getRangeType())){
                    AssertUtils.isNotEmpty(o.getIsOnlyCurrent(),"组织范围信息的范围属性不能为空");
                }
                rangeSet.add(o.getRangeType()+o.getRangeCode());
            });
            AssertUtils.isTrue(rangeVos.size()==rangeSet.size(),"范围信息重复,请检查后重新提交");
        }
        reqVo.setRangeVos(rangeVos);
        if (StringUtils.isEmpty(reqVo.getIsAllowRepeatAudit())) {
            reqVo.setIsAllowRepeatAudit(GlobalWhetherEnum.NO.getCode());
        }
        //校验活动类型关联的投入类型数据
        this.checkCategoriesAssociatedData(reqVo);
        this.checkDataExist(reqVo);
    }


    /**
     * 保存活动细类和活动大类的关联数据(仅酒类TPM使用)
     * @param reqVo
     */
    public void saveCategoriesAssociatedData(TpmCostTypeFineReqVo reqVo) {
        //如果是酒类tpm传来的数据，就处关于范围信息的数据
        if(StringUtils.isNotEmpty(reqVo.getId())){
            //更新范围数据,先根据有id的数据,把数据库里面需要删除的数据删除
            List<String> ids=Lists.newArrayList();
            if(CollectionUtils.isNotEmpty(reqVo.getRangeVos())){
                ids= reqVo.getRangeVos().stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmCostTypeCategoriesRangeReqVo::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper<TpmCostTypeCategoriesRangeEntity> queryWrapper = new LambdaQueryWrapper<TpmCostTypeCategoriesRangeEntity>().eq(TpmCostTypeCategoriesRangeEntity::getCategoriesCode, reqVo.getFineCode()).notIn(CollectionUtils.isNotEmpty(ids),TpmCostTypeCategoriesRangeEntity::getId,ids );
            rangeMapper.delete(queryWrapper);
        }
        if(CollectionUtils.isNotEmpty(reqVo.getRangeVos())){
            List<TpmCostTypeCategoriesRangeEntity> rangeEntities = reqVo.getRangeVos().stream().map(o -> {
                TpmCostTypeCategoriesRangeEntity rangeEntity = new TpmCostTypeCategoriesRangeEntity();
                CrmBeanUtil.copyProperties(o, rangeEntity);
                rangeEntity.setCategoriesCode(reqVo.getFineCode());
                return rangeEntity;
            }).collect(Collectors.toList());
            rangeService.saveOrUpdateBatch(rangeEntities);
        }

        if(StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids=Lists.newArrayList();
            if(CollectionUtils.isNotEmpty(reqVo.getTpmCostTypeCategoriesFineReqVo())) {
                ids = reqVo.getTpmCostTypeCategoriesFineReqVo().stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmCostTypeCategoriesFineReqVo::getId).collect(Collectors.toList());
            }
            //更新细类数据,先根据有id的数据,把数据库里面需要删除的数据删除
            LambdaQueryWrapper<TpmCostTypeCategoriesFineEntity> fineWrapper = new LambdaQueryWrapper<TpmCostTypeCategoriesFineEntity>().eq(TpmCostTypeCategoriesFineEntity::getFineCode, reqVo.getFineCode()).notIn(CollectionUtils.isNotEmpty(ids),TpmCostTypeCategoriesFineEntity::getId,ids );
            fineMapper.delete(fineWrapper);
        }
        if(CollectionUtils.isNotEmpty(reqVo.getTpmCostTypeCategoriesFineReqVo())){
            List<TpmCostTypeCategoriesFineEntity> fineEntities = reqVo.getTpmCostTypeCategoriesFineReqVo().stream().map(o -> {
                TpmCostTypeCategoriesFineEntity fineEntity = new TpmCostTypeCategoriesFineEntity();
                CrmBeanUtil.copyProperties(o, fineEntity);
                fineEntity.setFineCode(reqVo.getFineCode());
                return fineEntity;
            }).collect(Collectors.toList());
            fineService.saveOrUpdateBatch(fineEntities);
        }
    }

    /**
     * 校验活动类型关联的投入类型数据
     * @param reqVo
     */
    public void checkCategoriesAssociatedData(TpmCostTypeFineReqVo reqVo){
        if(CollectionUtils.isNotEmpty(reqVo.getTpmCostTypeCategoriesFineReqVo())){
            Set<String> set = Sets.newHashSet();
            reqVo.getTpmCostTypeCategoriesFineReqVo().forEach(o->{
                AssertUtils.isNotEmpty(o.getCategoriesCode(),"活动类型关联的投入类型编码不能为空");
                set.add(o.getCategoriesCode());
            });
            AssertUtils.isTrue(set.size() == reqVo.getTpmCostTypeCategoriesFineReqVo().size(),"关联细类数据重复,请检查后重新提交");
        }
    }

}
