package com.biz.crm.costtypefine.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.costtypefine.mapper.TpmActCollectFieldFineMapper;
import com.biz.crm.costtypefine.model.TpmActCollectFieldFineEntity;
import com.biz.crm.costtypefine.service.ITpmActCollectFieldFineService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmActCollectFieldFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmActCollectFieldFineRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 活动采集字段表与活动细类的关联表;接口实现
 *
 * @author zeyi
 * @date 2020-11-04 16:23:54
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmActCollectFieldFineServiceExpandImpl")
public class TpmActCollectFieldFineServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmActCollectFieldFineMapper, TpmActCollectFieldFineEntity> implements ITpmActCollectFieldFineService {

    @Resource
    private TpmActCollectFieldFineMapper tpmActCollectFieldFineMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmActCollectFieldFineRespVo> findList(TpmActCollectFieldFineReqVo reqVo){
        Page<TpmActCollectFieldFineRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmActCollectFieldFineRespVo> list = tpmActCollectFieldFineMapper.findList(page, reqVo);
        return PageResult.<TpmActCollectFieldFineRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmActCollectFieldFineRespVo
     */
    @Override
    public TpmActCollectFieldFineRespVo query(TpmActCollectFieldFineReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmActCollectFieldFineReqVo reqVo){
        TpmActCollectFieldFineEntity entity = CrmBeanUtil.copy(reqVo,TpmActCollectFieldFineEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmActCollectFieldFineReqVo reqVo){
        TpmActCollectFieldFineEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmActCollectFieldFineReqVo reqVo){
        List<TpmActCollectFieldFineEntity> tpmActCollectFieldFineEntities = tpmActCollectFieldFineMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmActCollectFieldFineEntities)){
            tpmActCollectFieldFineEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmActCollectFieldFineEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmActCollectFieldFineReqVo reqVo){
        //设置状态为启用
        List<TpmActCollectFieldFineEntity> tpmActCollectFieldFineEntities = tpmActCollectFieldFineMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmActCollectFieldFineEntities)){
            tpmActCollectFieldFineEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmActCollectFieldFineEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmActCollectFieldFineReqVo reqVo){
        //设置状态为禁用
        List<TpmActCollectFieldFineEntity> tpmActCollectFieldFineEntities = tpmActCollectFieldFineMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmActCollectFieldFineEntities)){
                tpmActCollectFieldFineEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmActCollectFieldFineEntities);
    }
}
