package com.biz.crm.feebudget.controller;

import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailReportReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailReportRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailsRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import java.util.List;

import com.biz.crm.aop.CrmLog;

/**
 * 费用预算明细 
 *
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */
@Slf4j
@RestController
@RequestMapping("/tpmFeeBudgetDetailsController")
@Api(tags = "费用预算明细 ")
public class TpmFeeBudgetDetailsController {
    @Autowired
    private ITpmFeeBudgetDetailsService tpmFeeBudgetDetailsService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmFeeBudgetDetailsRespVo>> list(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
        PageResult<TpmFeeBudgetDetailsRespVo> result=tpmFeeBudgetDetailsService.findList(tpmFeeBudgetDetailsReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmFeeBudgetDetailsRespVo> query(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
        TpmFeeBudgetDetailsRespVo respVo=tpmFeeBudgetDetailsService.query(tpmFeeBudgetDetailsReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
        tpmFeeBudgetDetailsService.save(tpmFeeBudgetDetailsReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo) {
        tpmFeeBudgetDetailsService.update(tpmFeeBudgetDetailsReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmFeeBudgetDetailsService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmFeeBudgetDetailsService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmFeeBudgetDetailsService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    @ApiOperation("费用预算明细报表")
    @PostMapping("feeBudgetDetailReport")
    @CrmLog
    public Result<PageResult<TpmFeeBudgetDetailReportRespVo>> feeBudgetDetailReport(@RequestBody TpmFeeBudgetDetailReportReqVo reportReqVo){
        return Result.ok(tpmFeeBudgetDetailsService.feeBudgetDetailReport(reportReqVo));
    }
}
