package com.biz.crm.feebudget.mapper;

import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import java.util.List;
import java.util.Map;

/**
 * 费用预算管控维度表 
 * 
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */
public interface TpmFeeBudgetControlMapper extends BaseMapper<TpmFeeBudgetControlEntity> {
    /**
     * 列表
     * @param page
     * @param tpmFeeBudgetControlReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a.create_pos_code",orgCode = "a.org_code")
    List<TpmFeeBudgetControlRespVo> findList(Page<TpmFeeBudgetControlRespVo> page, @Param("vo") TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 酒类Tpm 选择预算
     * @param page
     * @param tpmFeeBudgetControlReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a.create_pos_code",orgCode = "a.org_code")
    List<TpmFeeBudgetControlRespVo> findControlList(Page<TpmFeeBudgetControlRespVo> page, @Param("vo") TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);
}
