package com.biz.crm.feebudget.mapper;

import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailReportReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailReportRespVo;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailsRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailsReqVo;
import java.util.List;

/**
 * 费用预算明细 
 * 
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */
public interface TpmFeeBudgetDetailsMapper extends BaseMapper<TpmFeeBudgetDetailsEntity> {
    /**
     * 列表
     * @param page
     * @param tpmFeeBudgetDetailsReqVo
     * @return
     */
    List<TpmFeeBudgetDetailsRespVo> findList(Page<TpmFeeBudgetDetailsRespVo> page, @Param("vo") TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 根据费用预算编码查询明细数量
     * @param feeBudgetCode
     * @return
     */
    Integer getDetailCountByFeeBudgetCode(@Param("feeBudgetCode")String feeBudgetCode);

    /**
     * 费用预算明细报表
     * @param page
     * @param reportReqVo
     * @return
     */
    List<TpmFeeBudgetDetailReportRespVo> feeBudgetDetailReport(Page<TpmFeeBudgetDetailReportRespVo> page, @Param("vo") TpmFeeBudgetDetailReportReqVo reportReqVo);
}
