package com.biz.crm.feebudget.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDistributionReqVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDistributionRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 费用预算 
 * 
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */
public interface TpmFeeBudgetMapper extends BaseMapper<TpmFeeBudgetEntity> {
    /**
     * 列表
     * @param page
     * @param tpmFeeBudgetReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a.create_pos_code",orgCode = "a.org_code")
    List<TpmFeeBudgetRespVo> findList(Page<TpmFeeBudgetRespVo> page, @Param("vo") TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 全选修改(启用)
     * @param entity
     * @param reqVo
     */
    void updateBySelectAll(@Param("vo")TpmFeeBudgetEntity entity, @Param("entity")TpmFeeBudgetReqVo reqVo);

    /**
     * 删除
     * @param reqVo
     */
    void deleteByParams(@Param("vo") TpmFeeBudgetReqVo reqVo);

    /**
     * 删除时统计费用预算的明细数量
     * @param ids
     * @return
     */
    List<TpmFeeBudgetRespVo> countDetailsNum(@Param("ids") List<String> ids);
}
