package com.biz.crm.feebudget.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 费用预算 实体类
 *
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_fee_budget")
@CrmTable(name = "tpm_fee_budget",tableNote = "TPM-费用预算")
public class TpmFeeBudgetEntity extends CrmExtEntity<TpmFeeBudgetEntity> {

    /**
     * 关联管控维度表id
     */
    @CrmColumn(name = "control_id", length = 32,note = "关联管控维度表id")
    private String controlId;
    /**
     * 费用预算编码
     */
    @CrmColumn(name = "fee_budget_code", length = 32,note = "费用预算编码")
    private String feeBudgetCode;

    /**
     * 费用预算类型(字典)
     */
    @CrmColumn(name = "fee_budget_type", length = 32,note = "费用预算类型(字典)")
    private String feeBudgetType;

    /**
     * 预算年份(字典)
     */
    @CrmColumn(name = "budget_year", length = 32,note = "预算年份(字典)")
    private String budgetYear;

    /**
     * 预算季度(字典)
     */
    @CrmColumn(name = "budget_quater", length = 32,note = "预算季度(字典)")
    private String budgetQuater;

    /**
     * 预算月份(字典)
     */
    @CrmColumn(name = "budget_month", length = 32,note = "预算月份(字典)")
    private String budgetMonth;

    /**
     * 客户所属组织编码
     */
    @CrmColumn(name = "customer_org_code", length = 32,note = "客户所属组织编码")
    private String customerOrgCode;
    /**
     * 客户所属组织名称
     */
    @CrmColumn(name = "customer_org_name", length = 32,note = "客户所属组织名称")
    private String customerOrgName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 预算科目编码
     */
    @CrmColumn(name = "budget_subjects_code", length = 32,note = "预算科目编码")
    private String budgetSubjectsCode;

    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32,note = "产品层级编码")
    private String productLevelCode;

    /**
     *产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 60,note = "产品层级名称")
    private String productLevelName;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32,note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 60,note = "产品名称")
    private String productName;

    /**
     * 期初金额
     */
    @CrmColumn(name = "init_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "期初金额")
    private BigDecimal initAmount;
    /**
     * 调整金额
     */
    @CrmColumn(name = "adjust_total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "调整金额")
    private BigDecimal adjustTotalAmount;

    /**
     * 调整后金额
     */
    @CrmColumn(name = "after_adjust_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "调整后金额")
    private BigDecimal afterAdjustAmount;

    /**
     * 已使用金额
     */
    @CrmColumn(name = "used_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "已使用金额")
    private BigDecimal usedAmount;
    /**
     * 可用余额
     */
    @CrmColumn(name = "can_use_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "可用余额")
    private BigDecimal canUseAmount;
    /**
     * 企业组织编码
     */
    @CrmColumn(name = "org_code", length = 32,note = "企业组织编码")
    private String orgCode;

    /**
     * 企业组织名称
     */
    @CrmColumn(name = "org_name", length = 60,note = "企业组织名称")
    private String orgName;

    /**
     * 企业组织类型
     */
    @CrmColumn(name = "org_type", length = 32,note = "企业组织类型")
    private String orgType;

    /**
     * 企业组织类型名称
     */
    @CrmColumn(name = "org_type_name", length = 60,note = "企业组织类型名称")
    private String orgTypeName;

    /**
     * 渠道(字典)
     */
    @CrmColumn(name = "channel", length = 32,note = "渠道(字典)")
    private String channel;

    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 60,note = "门店名称")
    private String terminalName;

}
