package com.biz.crm.feebudget.service;

import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDistributionReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDistributionRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 费用预算 接口
 *
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */
public interface ITpmFeeBudgetService extends IService<TpmFeeBudgetEntity> {

    /**
     * 列表
     * @param tpmFeeBudgetReqVo
     * @return PageResult<TpmFeeBudgetRespVo>
     */
    PageResult<TpmFeeBudgetRespVo> findList(TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 查询
     * @param id
     * @return TpmFeeBudgetRespVo
     */
    TpmFeeBudgetRespVo query(String id);

    /**
     * 新增
     * @param tpmFeeBudgetReqVo
     * @return
     */
    void save(TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 更新
     * @param tpmFeeBudgetReqVo
     * @return
     */
    void update(TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 变更
     * @param tpmFeeBudgetReqVo
     */
    void change(TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 调整
     * @param tpmFeeBudgetReqVo
     */
    void adjust(TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 保存费用预算划拨
     * @param reqVos
     */
    void saveDistribution(List<TpmFeeBudgetDistributionReqVo> reqVos);
}

