package com.biz.crm.feebudget.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.eunm.tpm.ActTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.BudgetUseDateRuleEnum;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.parameter.feign.ParameterFeign;
import com.biz.crm.parameter.vo.ParameterVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import org.apache.commons.collections4.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import javax.annotation.Resource;

/**
 * 费用预算管控维度表 接口实现
 *
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmFeeBudgetControlServiceExpandImpl")
public class TpmFeeBudgetControlServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmFeeBudgetControlMapper, TpmFeeBudgetControlEntity> implements ITpmFeeBudgetControlService {

    @Resource
    private TpmFeeBudgetControlMapper tpmFeeBudgetControlMapper;

    @Autowired
    private ITpmFeeBudgetService feeBudgetService;

    @Autowired
    private FeeBudgetServiceHelper feeBudgetServiceHelper;




    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmFeeBudgetControlRespVo> findList(TpmFeeBudgetControlReqVo reqVo){
        Page<TpmFeeBudgetControlRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        //根据活动的开始日期和结束日期+获取字典配置的项目的费用是当前区间还是当前区间以及未来区间配置,来匹配预算维度的selectKey
        Set<String> selectKeys = getSelectKeys(reqVo);
        reqVo.setSelectKeys(selectKeys);
        reqVo.setSelectedCodeList(feeBudgetServiceHelper.dealSelectedCodeList(reqVo.getSelectedCode(),reqVo.getSelectedCodeList()));
        List<TpmFeeBudgetControlRespVo> list = tpmFeeBudgetControlMapper.findList(page, reqVo);
        //根据控制维度集合查询
        this.convertListData(list);
        return PageResult.<TpmFeeBudgetControlRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<TpmFeeBudgetControlRespVo> list(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
        Page<TpmFeeBudgetControlRespVo> page = PageUtil.buildPage(tpmFeeBudgetControlReqVo.getPageNum(), -1);
        List<TpmFeeBudgetControlRespVo> list = tpmFeeBudgetControlMapper.findList(page, tpmFeeBudgetControlReqVo);
        this.convertListData(list);
        return list;
    }

    /**
     * 活动查询费用预算维度时,通过开始结束时间获取selectKey
     * @param reqVo
     * @return
     */
    public Set<String> getSelectKeys(TpmFeeBudgetControlReqVo reqVo){
        //获取区间的配置字典
        String config = ParamUtil.getParameterValue(TpmGlobalDictConstants.BUDGET_USE_DATE_RULE);
        AssertUtils.isNotEmpty(config,"未获取到预算选择时间控制开关配置");
        Set<String> set = Sets.newHashSet();
        //如果获取到的值为不控制(no_control),直接返回空集合
        if(StringUtils.equals(BudgetUseDateRuleEnum.NO_CONTROL.getCode(),config)){
            return set;
        }
        AssertUtils.isNotEmpty(reqVo.getActBeginDate(),"活动开始时间不能为空");
        AssertUtils.isNotEmpty(reqVo.getActEndDate(),"活动结束时间不能为空");
        //如果获取到的值为当前区间(current)
        if(StringUtils.equals(BudgetUseDateRuleEnum.CURRENT.getCode(),config)){
            Map<Integer, List<Integer>> dateMap = DateUtil.getDateBetweenMap(reqVo.getActBeginDate(), reqVo.getActEndDate());
            for (Map.Entry<Integer, List<Integer>> entry : dateMap.entrySet()) {
                String key = entry.getKey().toString();
                List<Integer> months = entry.getValue();
                //设置年
                set.add(key);
                for (Integer month : months) {
                    //当前月份对应的季度
                    int quater = DateUtil.getQuaterByMonth(month);
                    String yearQuater = key +"-"+ quater;
                    if(!set.contains(yearQuater)){
                       set.add(yearQuater) ;
                    }
                    //处理月份
                    set.add(yearQuater+"-"+month);
                }
            }
        }else {
            throw new BusinessException("预算选择时间控制开关配置值错误");
        }
        return set;
    }
    /**
     * 根据控制维度集合查询
     * @param list
     */
    @Override
    public void convertListData(List<TpmFeeBudgetControlRespVo> list){
        if(CollectionUtils.isNotEmpty(list)){
            Map<String, Map<String, String>> dicts = feeBudgetServiceHelper.getDicts();
            List<String> ids = list.stream().map(TpmFeeBudgetControlRespVo::getId).collect(Collectors.toList());
            TpmFeeBudgetReqVo tpmFeeBudgetReqVo = new TpmFeeBudgetReqVo();
            tpmFeeBudgetReqVo.setPageSize(-1);
            tpmFeeBudgetReqVo.setControlIds(ids);
            ThreadLocalUtil.delObj();
            List<TpmFeeBudgetRespVo> feeBudgetServiceList = feeBudgetService.findList(tpmFeeBudgetReqVo).getData();
            if (CollectionUtils.isEmpty(feeBudgetServiceList)){
                return;
            }
            Map<String, List<TpmFeeBudgetRespVo>> map = feeBudgetServiceList.stream().collect(Collectors.groupingBy(TpmFeeBudgetRespVo::getControlId));
            list.forEach(o->{
                List<TpmFeeBudgetRespVo> tpmFeeBudgetRespVos = map.get(o.getId());
                if(CollectionUtil.listNotEmptyNotSizeZero(tpmFeeBudgetRespVos)){
                    o.setBudgetSubjectsName(tpmFeeBudgetRespVos.get(0).getBudgetSubjectsName());
                    o.setFeeBudgetVos(tpmFeeBudgetRespVos);
                }
                //年份
                if(StringUtils.isNotEmpty(o.getBudgetYear())){
                    o.setBudgetYearName(Optional.ofNullable(dicts.get(TpmGlobalDictConstants.FISCAL_YEAR)).orElse(Maps.newHashMap()).get(o.getBudgetYear()));
                }
                //月份
                if(StringUtils.isNotEmpty(o.getBudgetMonth())) {
                    o.setBudgetMonthName(Optional.ofNullable(dicts.get(TpmGlobalDictConstants.FISCAL_MONTH)).orElse(Maps.newHashMap()).get(o.getBudgetMonth()));
                }
                //季度
                if(StringUtils.isNotEmpty(o.getBudgetQuater())){
                    o.setBudgetQuaterName(Optional.ofNullable(dicts.get(TpmGlobalDictConstants.FISCAL_QUATER)).orElse(Maps.newHashMap()).get(o.getBudgetQuater()));
                }
                //渠道
                if(StringUtils.isNotEmpty(o.getChannel())){
                    o.setChannelName(Optional.ofNullable(dicts.get(TpmGlobalDictConstants.CHANNEL)).orElse(Maps.newHashMap()).get(o.getChannel()));
                }
                //费用预算类型
                if(StringUtils.isNotEmpty(o.getFeeBudgetType())){
                    o.setFeeBudgetTypeName(Optional.ofNullable(dicts.get(TpmGlobalDictConstants.FEE_BUDGET_TYPE)).orElse(Maps.newHashMap()).get(o.getFeeBudgetType()));
                }
                //控制类型
                if(StringUtils.isNotEmpty(o.getControlType())){
                    o.setControlTypeName(Optional.ofNullable(dicts.get(TpmGlobalDictConstants.CONTROL_TYPE)).orElse(Maps.newHashMap()).get(o.getControlType()));
                }
            });
        }
    }
    /**
     * 查询
     * @param reqVo
     * @return tpmFeeBudgetControlRespVo
     */
    @Override
    public TpmFeeBudgetControlRespVo query(TpmFeeBudgetControlReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmFeeBudgetControlReqVo reqVo){
        TpmFeeBudgetControlEntity entity = CrmBeanUtil.copy(reqVo,TpmFeeBudgetControlEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmFeeBudgetControlReqVo reqVo){
        TpmFeeBudgetControlEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmFeeBudgetControlEntity> tpmFeeBudgetControlEntities = tpmFeeBudgetControlMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmFeeBudgetControlEntities)){
            tpmFeeBudgetControlEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmFeeBudgetControlEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmFeeBudgetControlEntity> tpmFeeBudgetControlEntities = tpmFeeBudgetControlMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmFeeBudgetControlEntities)){
            tpmFeeBudgetControlEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmFeeBudgetControlEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmFeeBudgetControlEntity> tpmFeeBudgetControlEntities = tpmFeeBudgetControlMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmFeeBudgetControlEntities)){
                tpmFeeBudgetControlEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmFeeBudgetControlEntities);
    }
}
