package com.biz.crm.feebudget.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailReportReqVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailsReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailReportRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailsRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 费用预算明细 接口实现
 *
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmFeeBudgetDetailsServiceExpandImpl")
public class TpmFeeBudgetDetailsServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmFeeBudgetDetailsMapper, TpmFeeBudgetDetailsEntity> implements ITpmFeeBudgetDetailsService {

    @Resource
    private TpmFeeBudgetDetailsMapper tpmFeeBudgetDetailsMapper;

    @Resource
    private ActServiceHelper actServiceHelper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmFeeBudgetDetailsRespVo> findList(TpmFeeBudgetDetailsReqVo reqVo){
        Page<TpmFeeBudgetDetailsRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setSelectedCodeList(actServiceHelper.dealSelectedCodeList(reqVo.getSelectedCode(),reqVo.getSelectedCodeList()));
        List<TpmFeeBudgetDetailsRespVo> list = tpmFeeBudgetDetailsMapper.findList(page, reqVo);
        return PageResult.<TpmFeeBudgetDetailsRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmFeeBudgetDetailsRespVo
     */
    @Override
    @CrmLog
    public TpmFeeBudgetDetailsRespVo query(TpmFeeBudgetDetailsReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(TpmFeeBudgetDetailsReqVo reqVo){
        TpmFeeBudgetDetailsEntity entity = CrmBeanUtil.copy(reqVo,TpmFeeBudgetDetailsEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmFeeBudgetDetailsReqVo reqVo){
        TpmFeeBudgetDetailsEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids){
        List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = tpmFeeBudgetDetailsMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmFeeBudgetDetailsEntities)){
            tpmFeeBudgetDetailsEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmFeeBudgetDetailsEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = tpmFeeBudgetDetailsMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmFeeBudgetDetailsEntities)){
            tpmFeeBudgetDetailsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmFeeBudgetDetailsEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = tpmFeeBudgetDetailsMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmFeeBudgetDetailsEntities)){
                tpmFeeBudgetDetailsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmFeeBudgetDetailsEntities);
    }

    @Override
    public PageResult<TpmFeeBudgetDetailReportRespVo> feeBudgetDetailReport(TpmFeeBudgetDetailReportReqVo reqVo) {
        Page<TpmFeeBudgetDetailReportRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmFeeBudgetDetailReportRespVo> list = tpmFeeBudgetDetailsMapper.feeBudgetDetailReport(page, reqVo);
        convertData(list);
        return PageResult.<TpmFeeBudgetDetailReportRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    private void convertData(List<TpmFeeBudgetDetailReportRespVo> data){
        if(CollectionUtil.listNotEmpty(data)){
            Map<String, Map<String, String>> dictMap = DictUtil.getDictValueMapsByCodes(Lists.newArrayList(TpmGlobalDictConstants.FEE_BUDGET_TYPE, TpmGlobalDictConstants.FEE_BUDGET_DETAIL_TYPE));
            data.forEach(o -> {
                o.setFeeBudgetType(Optional.ofNullable(dictMap.get(TpmGlobalDictConstants.FEE_BUDGET_TYPE)).orElse(Maps.newHashMap()).get(o.getFeeBudgetType()));
                o.setFeeBudgetDetailType(Optional.ofNullable(dictMap.get(TpmGlobalDictConstants.FEE_BUDGET_DETAIL_TYPE)).orElse(Maps.newHashMap()).get(o.getFeeBudgetDetailType()));
            });
        }
    }
}
