package com.biz.crm.feerateform.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.feerateform.service.FeeRateFormService;
import com.biz.crm.nebular.tpm.feerateform.FeeRateFormReqVo;
import com.biz.crm.nebular.tpm.feerateform.FeeRateFormRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author hx
 * @ClassName FeeRateFormController
 * @Description 费用率报表controller
 * @date 2022/03/29
 */
@Api(value = "费用率报表", tags = "费用率报表")
@RestController
@RequestMapping("/feeRateFormController")
public class FeeRateFormController {

    @Resource
    private FeeRateFormService feeRateFormService;

    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<FeeRateFormRespVo>> list(@RequestBody FeeRateFormReqVo reqVo) {
        return Result.ok(feeRateFormService.list(reqVo));
    }
}
