package com.biz.crm.feerateform.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.feerateform.mapper.FeeRateFormMapper;
import com.biz.crm.feerateform.service.FeeRateFormService;
import com.biz.crm.nebular.tpm.feerateform.FeeRateFormReqVo;
import com.biz.crm.nebular.tpm.feerateform.FeeRateFormRespVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author hx
 * @ClassName FeeRateFormServiceImpl
 * @Description
 * @date 2022/03/29
 */
@Service
public class FeeRateFormServiceImpl implements FeeRateFormService {

    @Resource
    private FeeRateFormMapper feeRateFormMapper;

    @Override
    public PageResult<FeeRateFormRespVo> list(FeeRateFormReqVo reqVo) {
        Integer month = Integer.parseInt(reqVo.getYearMonth().substring(5, 7));
        //获取上月的年月
        Date yearMonthDate = DateUtil.parse(reqVo.getYearMonth(), "yyyy-MM");
        Calendar lastMonth = Calendar.getInstance();
        lastMonth.setTime(yearMonthDate);
        lastMonth.add(Calendar.MONTH, -1);
        String lastMonthStr = DateUtil.yyyy_MM.format(lastMonth.getTime());
        reqVo.setLastMonth(lastMonthStr);

        Page<FeeRateFormRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<FeeRateFormRespVo> pageList = feeRateFormMapper.findPageList(page, reqVo);

        for (FeeRateFormRespVo v : pageList) {
            v.setMonth(month);
            if (BigDecimal.ZERO.compareTo(v.getAmountSum()) != 0) {
                v.setRate(v.getApplyAmountSum().multiply(new BigDecimal(100)).divide(v.getAmountSum(),0, BigDecimal.ROUND_DOWN));
            }
        }

        return PageResult.<FeeRateFormRespVo>builder()
                .data(pageList)
                .count(page.getTotal())
                .build();
    }
}
