package com.biz.crm.financesubject.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @author maoshen
 * @date 2021/2/20.
 */
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_finance_subject")
@Getter
@Setter
@CrmTable(name = "tpm_finance_subject",tableNote = "TPM-财务科目")
public class TpmFinanceSubjectEntity extends CrmExtEntity<TpmFinanceSubjectEntity> {
    /**
     * 财务科目编码
     */
    @CrmColumn(name = "finance_subject_code", length = 32,note = "财务科目编码")
    private String financeSubjectCode;


    /**
     * 财务科目名称
     */
    @CrmColumn(name = "finance_subject_name", length = 60,note = "财务科目名称")
    private String financeSubjectName;

    /**
     * 财务科目类型
     */
    @CrmColumn(name = "finance_subject_type", length = 32,note = "财务科目类型")
    private String financeSubjectType;
}
