package com.biz.crm.financesubject.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/2/20.
 */
public interface TpmFinanceSubjectService extends IService<TpmFinanceSubjectEntity> {
    /**
     * 查询列表
     * @param reqVo
     * @return
     */
    PageResult<TpmFinanceSubjectRespVo> findList(TpmFinanceSubjectReqVo reqVo);

    /**
     * 查询单个
     * @param id
     * @return
     */
    TpmFinanceSubjectRespVo queryView(String id);

    /**
     * 新增财务科目
     * @param reqVo
     */
    void save(TpmFinanceSubjectReqVo reqVo);

    /**
     * 修改财务科目
     * @param reqVo
     */
    void update(TpmFinanceSubjectReqVo reqVo);

    /**
     * 批量删除财务科目
     * @param ids ids
     */
    void batchDelete(List<String> ids);

    /**
     * 批量禁用
     * @param ids ids
     */
    void batchDisable(List<String> ids);

    /**
     * 批量启用
     * @param ids ids
     */
    void batchEnable(List<String> ids);
}
