package com.biz.crm.fiscalyear.mapper;

import com.biz.crm.fiscalyear.model.TpmFiscalYearSettingEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import java.util.List;

/**
 * 财年设置 财年设置表
 * 
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */
public interface TpmFiscalYearSettingMapper extends BaseMapper<TpmFiscalYearSettingEntity> {
    /**
     * 列表
     * @param page
     * @param tpmFiscalYearSettingReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmFiscalYearSettingRespVo> findList(Page<TpmFiscalYearSettingRespVo> page, @Param("vo") TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 删除财年数据
     * @param tpmFiscalYearSettingReqVo
     * @return
     */
    void deleteProductsByParams(@Param("vo")TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);
}
