package com.biz.crm.fiscalyear.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;




/**
 * 财年设置 财年设置表实体类
 *
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_fiscal_year_setting")
@CrmTable(name = "tpm_fiscal_year_setting",tableNote = "TPM-财年设置")
public class TpmFiscalYearSettingEntity extends CrmExtEntity<TpmFiscalYearSettingEntity> {

    /**
     * 预算年(字典编码)
     */
    @CrmColumn(name = "year", length = 32,note = "预算年(字典编码)")
    private String year;

    /**
     * 预算季度(字典编码)
     */
    @CrmColumn(name = "quater", length = 32,note = "预算季度(字典编码)")
    private String quater;

    /**
     * 预算月度(字典编码)
     */
    @CrmColumn(name = "month", length = 32,note = "预算月度(字典编码)")
    private String month;

    /**
     * 开始日期
     */
    @CrmColumn(name = "begin_date", length = 32,note = "开始日期")
    private String beginDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date_second", length = 32,note = "开始时间")
    private String beginDateSecond;

    /**
     * 结束日期
     */
    @CrmColumn(name = "end_date", length = 32,note = "结束日期")
    private String endDate;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date_second", length = 32,note = "结束时间")
    private String endDateSecond;

    /**
     * 半年度（字典编码）
     */
    @CrmColumn(name = "half_year", length = 32,note = "半年度（字典编码）")
    private String halfYear;

}
