package com.biz.crm.fiscalyear.service;

import com.biz.crm.fiscalyear.model.TpmFiscalYearSettingEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;

import java.util.List;

/**
 * 财年设置 财年设置表接口
 *
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */
public interface ITpmFiscalYearSettingService extends IService<TpmFiscalYearSettingEntity> {

    /**
     * 列表
     * @param tpmFiscalYearSettingReqVo
     * @return PageResult<TpmFiscalYearSettingRespVo>
     */
    PageResult<TpmFiscalYearSettingRespVo> findList(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 查询
     * @param id
     * @return TpmFiscalYearSettingRespVo
     */
    TpmFiscalYearSettingRespVo query(String id);

    /**
     * 新增
     * @param tpmFiscalYearSettingReqVo
     * @return
     */
    void save(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 更新
     * @param tpmFiscalYearSettingReqVo
     * @return
     */
    void update(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

