package com.biz.crm.fiscalyear.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.mdm.MdmCusMaterialException;
import com.biz.crm.exception.tpm.BudgetSubjectsException;
import com.biz.crm.exception.tpm.FiscalYearSettingException;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.fiscalyear.model.TpmFiscalYearSettingEntity;
import com.biz.crm.fiscalyear.mapper.TpmFiscalYearSettingMapper;
import com.biz.crm.fiscalyear.service.ITpmFiscalYearSettingService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Objects;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 财年设置 财年设置表接口实现
 *
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmFiscalYearSettingServiceExpandImpl")
public class TpmFiscalYearSettingServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmFiscalYearSettingMapper, TpmFiscalYearSettingEntity> implements ITpmFiscalYearSettingService {

    @Resource
    private TpmFiscalYearSettingMapper tpmFiscalYearSettingMapper;
    @Autowired
    private FiscalYearSettingServiceHelper serviceHelper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    /**
     * 列表
     * @param tpmFiscalYearSettingReqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmFiscalYearSettingRespVo> findList(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo){
        Page<TpmFiscalYearSettingRespVo> page = PageUtil.buildPage(tpmFiscalYearSettingReqVo.getPageNum(), tpmFiscalYearSettingReqVo.getPageSize());
        List<TpmFiscalYearSettingRespVo> list = tpmFiscalYearSettingMapper.findList(page, tpmFiscalYearSettingReqVo);
        serviceHelper.convertListDate(list);
        return PageResult.<TpmFiscalYearSettingRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tpmFiscalYearSettingRespVo
     */
    @Override
    @CrmLog
    public TpmFiscalYearSettingRespVo query(String id){
        AssertUtils.isNotEmpty(id, "id不能为空");
        TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo = new TpmFiscalYearSettingReqVo();
        tpmFiscalYearSettingReqVo.setId(id);
        List<TpmFiscalYearSettingRespVo> list = this.findList(tpmFiscalYearSettingReqVo).getData();
        if(CollectionUtils.isEmpty(list)){
//            throw new BusinessException(FiscalYearSettingException.DATA_NOT_EXIST);
            return new TpmFiscalYearSettingRespVo();
        }
        return list.get(0);
    }

    /**
     * 新增
     * @param tpmFiscalYearSettingReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo){
        serviceHelper.saveCheck(tpmFiscalYearSettingReqVo);
        TpmFiscalYearSettingEntity entity = CrmBeanUtil.copy(tpmFiscalYearSettingReqVo,TpmFiscalYearSettingEntity.class);
        this.save(entity);
        //日志
        TpmFiscalYearSettingRespVo newData = CrmBeanUtil.copy(entity, TpmFiscalYearSettingRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getBeginDateSecond(),newData);

    }

    /**
     * 更新
     * @param tpmFiscalYearSettingReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo){
        if(StringUtils.isEmpty(tpmFiscalYearSettingReqVo.getId())){
            throw new BusinessException("数据主键不能为空");
        }
        TpmFiscalYearSettingEntity entity = this.getById(tpmFiscalYearSettingReqVo.getId());
        //日志老数据
        TpmFiscalYearSettingRespVo oldData = CrmBeanUtil.copy(entity, TpmFiscalYearSettingRespVo.class);
        if(Objects.isNull(entity)){
            throw new BusinessException(FiscalYearSettingException.DATA_NOT_EXIST);
        }
        serviceHelper.saveCheck(tpmFiscalYearSettingReqVo);
        CrmBeanUtil.copyProperties(tpmFiscalYearSettingReqVo,entity);
        this.updateById(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmFiscalYearSettingRespVo newData = CrmBeanUtil.copy(entity, TpmFiscalYearSettingRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getBeginDateSecond(),oldData,newData);

    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids){
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        //日志老数据
        PageResult<TpmFiscalYearSettingRespVo> oldDataList = this.findList(new TpmFiscalYearSettingReqVo().setIds(ids));
        tpmFiscalYearSettingMapper.deleteBatchIds(ids);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (TpmFiscalYearSettingRespVo oldData:oldDataList.getData()) {
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),oldData.getId(),oldData.getBeginDateSecond(),oldData);
        }

    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids){
        //设置状态为启用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmFiscalYearSettingEntity> mdmProductEntities = tpmFiscalYearSettingMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmFiscalYearSettingRespVo> oldDataList = CrmBeanUtil.copyList(mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        if (CollectionUtils.isNotEmpty(mdmProductEntities)) {
            mdmProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductEntities);
        //日志
        List<TpmFiscalYearSettingRespVo> newDataList = CrmBeanUtil.copyList(mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getBeginDateSecond(),oldDataList.get(i),newDataList.get(i));
        }
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmFiscalYearSettingEntity> mdmProductEntities = tpmFiscalYearSettingMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmFiscalYearSettingRespVo> oldDataList = CrmBeanUtil.copyList(mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        if (CollectionUtils.isNotEmpty(mdmProductEntities)) {
            mdmProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductEntities);
        //日志
        List<TpmFiscalYearSettingRespVo> newDataList = CrmBeanUtil.copyList(mdmProductEntities, TpmFiscalYearSettingRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getBeginDateSecond(),oldDataList.get(i),newDataList.get(i));
        }
    }
}
