package com.biz.crm.income.controller;

import com.biz.crm.income.service.ITpmIncomeBudgetService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 收入预算;
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */
@Slf4j
@RestController
@RequestMapping("/tpmincomebudget")
@Api(tags = "收入预算;")
public class TpmIncomeBudgetController {
    @Autowired
    private ITpmIncomeBudgetService tpmIncomeBudgetService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmIncomeBudgetRespVo>> list(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        PageResult<TpmIncomeBudgetRespVo> result=tpmIncomeBudgetService.findList(tpmIncomeBudgetReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmIncomeBudgetRespVo> query(@RequestParam(value = "id", required = true) String id) {
        TpmIncomeBudgetRespVo respVo=tpmIncomeBudgetService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        tpmIncomeBudgetService.save(tpmIncomeBudgetReqVo);
        return Result.ok();
    }
    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        tpmIncomeBudgetService.update(tpmIncomeBudgetReqVo);
        return Result.ok("修改成功");
    }
    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/batchDelete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmIncomeBudgetService.batchDelete(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmIncomeBudgetService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmIncomeBudgetService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    @ApiOperation(value = "查询当前登陆人组织以及下级组织")
    @PostMapping("/findAllOrgCodes")
    @CrmLog
    public Result<List<MdmOrgRespVo>> findAllOrgCodes(@RequestBody MdmOrgReqVo mdmOrgReqVo){
        List<MdmOrgRespVo> orgCodesList= tpmIncomeBudgetService.findAllOrgCodes(mdmOrgReqVo);
        return Result.ok(orgCodesList);
    }

    @ApiOperation(value = "根据组织查询客户")
    @PostMapping("/findCustomerByOrgCode")
    @CrmLog
    public Result<List<MdmCustomerMsgRespVo>> findCustomerByOrgCode(@RequestBody MdmOrgReqVo mdmOrgReqVo){
        List<MdmCustomerMsgRespVo> customerMsgRespVos= tpmIncomeBudgetService.findCustomerByOrgCode(mdmOrgReqVo);
        return Result.ok(customerMsgRespVos);
    }

    @ApiOperation(value = "根据组织查询门店")
    @PostMapping("/findTerminalByOrgCode")
    @CrmLog
    public Result<List<MdmTerminalVo>> findTerminalByOrgCode(@RequestBody MdmOrgReqVo mdmOrgReqVo){
        List<MdmTerminalVo> terminalVos= tpmIncomeBudgetService.findTerminalByOrgCode(mdmOrgReqVo);
        return Result.ok(terminalVos);
    }

//    @ApiOperation(value = "获取所有产品")
//    @PostMapping("/findAllProduct")
//    @CrmLog
//    public Result<List<MdmProductRespVo>> findAllProduct(@RequestBody MdmProductReqVo mdmProductReqVo){
//        List<MdmProductRespVo> productRespVos= tpmIncomeBudgetService.findAllProduct(mdmProductReqVo);
//        return Result.ok(productRespVos);
//    }

    @ApiOperation(value = "获取所有产品层级")
    @PostMapping("/findAllProductLevel")
    @CrmLog
    public Result<List<MdmProductLevelSelectRespVo>> findAllProductLevel(@RequestBody MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo){
        List<MdmProductLevelSelectRespVo> productLevelSelectRespVos= tpmIncomeBudgetService.findAllProductLevel(mdmProductLevelSelectReqVo);
        return Result.ok(productLevelSelectRespVos);
    }

    @ApiOperation(value = "获取所有产品")
    @PostMapping("/findAllProductByLevelCode")
    @CrmLog
    public Result<List<MdmProductQueryRespVo>> findAllProductByLevelCode(@RequestBody MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo){
        List<MdmProductQueryRespVo> productRespVos= tpmIncomeBudgetService.findAllProductByLevelCode(mdmProductLevelSelectReqVo);
        return Result.ok(productRespVos);
    }
}
