package com.biz.crm.income.mapper;

import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Map;

/**
 * 收入预算;
 * 
 * @author lf
 * @date 2021-02-02 17:55:15
 */
@Mapper
public interface TpmIncomeBudgetMapper extends BaseMapper<TpmIncomeBudgetEntity> {
    /**
     * 列表
     * @param page
     * @param tpmIncomeBudgetReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmIncomeBudgetRespVo> findList(Page<TpmIncomeBudgetRespVo> page, @Param("vo") TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo);

}
